/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.infonode.util.ArrayUtil;
import net.infonode.util.Readable;
import net.infonode.util.Writable;

public class StreamUtil {
    public static final void readAll(InputStream in, byte[] data, int offset, int length) throws IOException {
        while (length > 0) {
            int len = in.read(data, offset, length);
            if (len == -1) {
                throw new IOException("End of stream reached!");
            }
            offset += len;
            length -= len;
        }
    }

    public static final byte[] readAll(InputStream is) throws IOException {
        byte[] data = new byte[is.available()];
        int pos = 0;
        while (pos < data.length) {
            pos += is.read(data, pos, data.length - pos);
        }
        is.close();
        return data;
    }

    public static final byte[] writeObject(Object object) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream o2 = new ObjectOutputStream(out);
        o2.writeObject(object);
        o2.close();
        return ArrayUtil.part(out.toByteArray(), 0, out.size());
    }

    public static final Object readObject(byte[] data) throws IOException, ClassNotFoundException {
        return new ObjectInputStream(new ByteArrayInputStream(data)).readObject();
    }

    public static byte[] write(Writable writable) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream o2 = new ObjectOutputStream(out);
        writable.write(o2);
        o2.close();
        return out.toByteArray();
    }

    public static void read(byte[] data, Readable readable) throws IOException {
        readable.read(new ObjectInputStream(new ByteArrayInputStream(data)));
    }

    public static void readAll(InputStream in, byte[] data) throws IOException {
        StreamUtil.readAll(in, data, 0, data.length);
    }

    public static void write(InputStream in, OutputStream out, int length) throws IOException {
        byte[] data = new byte[10000];
        while (length > 0) {
            int read = in.read(data, 0, Math.min(data.length, length));
            out.write(data, 0, read);
            length -= read;
        }
    }
}

