/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.tngtech.archunit.core.domain.JavaClass;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.freeplane.plugin.codeexplorer.task.GroupIdentifier;
import org.freeplane.plugin.codeexplorer.task.GroupMatcher;

class BundlingGroupMatcher
implements GroupMatcher {
    private final GroupMatcher matcher;
    private final Map<String, GroupIdentifier> bundledProjects;
    private final Set<String> bundledGroupIds;

    BundlingGroupMatcher(GroupMatcher matcher, Map<String, GroupIdentifier> bundledProjects) {
        this.matcher = matcher;
        this.bundledProjects = bundledProjects;
        this.bundledGroupIds = bundledProjects.values().stream().map(GroupIdentifier::getId).collect(Collectors.toSet());
    }

    @Override
    public Optional<GroupIdentifier> groupIdentifier(JavaClass javaClass) {
        return this.matcher.groupIdentifier(javaClass).map(gi -> this.bundledProjects.getOrDefault(gi.getId(), (GroupIdentifier)gi)).filter(gi -> !gi.getId().isEmpty());
    }

    @Override
    public Optional<GroupIdentifier> projectIdentifier(JavaClass javaClass) {
        return this.matcher.projectIdentifier(javaClass);
    }

    @Override
    public boolean belongsToGroup(JavaClass javaClass) {
        return this.groupIdentifier(javaClass).isPresent();
    }

    @Override
    public Optional<GroupMatcher> subgroupMatcher(final String groupId) {
        if (!this.bundledGroupIds.contains(groupId) && !this.matcher.subgroupMatcher(groupId).isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new GroupMatcher(){

            @Override
            public Optional<GroupIdentifier> groupIdentifier(JavaClass javaClass) {
                return BundlingGroupMatcher.this.subgroupIdentifier(javaClass, groupId);
            }

            @Override
            public Optional<GroupIdentifier> projectIdentifier(JavaClass javaClass) {
                return BundlingGroupMatcher.this.matcher.projectIdentifier(javaClass);
            }

            @Override
            public Optional<GroupMatcher> subgroupMatcher(String id) {
                return BundlingGroupMatcher.this.matcher.subgroupMatcher(id);
            }

            @Override
            public Optional<GroupMatcher.MatchingCriteria> matchingCriteria(JavaClass javaClass) {
                return BundlingGroupMatcher.this.matcher.matchingCriteria(javaClass);
            }

            @Override
            public Optional<GroupMatcher.MatchingCriteria> matchingCriteria(JavaClass originClass, JavaClass targetClass) {
                return BundlingGroupMatcher.this.matcher.matchingCriteria(originClass, targetClass);
            }
        });
    }

    private Optional<GroupIdentifier> subgroupIdentifier(JavaClass javaClass, String groupId) {
        Optional<GroupIdentifier> groupIdentifier = this.groupIdentifier(javaClass);
        if (!groupIdentifier.isPresent() || !groupIdentifier.get().getId().equals(groupId)) {
            return Optional.empty();
        }
        return this.matcher.groupIdentifier(javaClass);
    }
}

