/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.tngtech.archunit.core.domain.JavaClass;
import java.util.Map;
import java.util.Optional;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.task.BundlingGroupMatcher;
import org.freeplane.plugin.codeexplorer.task.GroupIdentifier;
import org.freeplane.plugin.codeexplorer.task.GroupMatcher;

class RmiMatcher
extends BundlingGroupMatcher
implements GroupMatcher {
    private final Map<JavaClass, GroupIdentifier> rmiClasses;

    RmiMatcher(GroupMatcher matcher, Map<String, GroupIdentifier> bundledGroups, Map<JavaClass, GroupIdentifier> rmiClasses) {
        super(matcher, bundledGroups);
        this.rmiClasses = rmiClasses;
    }

    @Override
    public Optional<GroupMatcher.MatchingCriteria> matchingCriteria(JavaClass javaClass) {
        return this.rmiClasses.containsKey(CodeNode.findEnclosingNamedClass(javaClass)) ? Optional.of(GroupMatcher.MatchingCriteria.RMI) : Optional.empty();
    }

    @Override
    public Optional<GroupMatcher.MatchingCriteria> matchingCriteria(JavaClass originClass, JavaClass targetClass) {
        GroupIdentifier originIdentifier = this.rmiClasses.get(CodeNode.findEnclosingNamedClass(originClass));
        if (originIdentifier == null) {
            return Optional.empty();
        }
        GroupIdentifier targetIdentifier = this.rmiClasses.get(CodeNode.findEnclosingNamedClass(targetClass));
        if (targetIdentifier == null) {
            return Optional.empty();
        }
        return !originIdentifier.equals(targetIdentifier) ? Optional.of(GroupMatcher.MatchingCriteria.RMI) : Optional.empty();
    }

    static enum Mode {
        IMPLEMENTATIONS,
        INSTANTIATIONS;

    }
}

