/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.DTOId;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

public class BundleNameVersionCapability
extends DTOId
implements BundleCapability {
    final BundleGeneration gen;
    final String namespace;

    BundleNameVersionCapability(BundleGeneration bundleGeneration, String namespace) {
        this.gen = bundleGeneration;
        this.namespace = namespace;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        if (this.gen.symbolicNameParameters != null) {
            return Collections.unmodifiableMap(this.gen.symbolicNameParameters.getDirectives());
        }
        Map res = Collections.EMPTY_MAP;
        return res;
    }

    @Override
    public Map<String, Object> getAttributes() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (this.gen.symbolicNameParameters != null) {
            res.putAll(this.gen.symbolicNameParameters.getAttributes());
        }
        if (this.gen.symbolicName != null) {
            res.put(this.namespace, this.gen.symbolicName);
            res.put("bundle-version", this.gen.version);
        }
        return Collections.unmodifiableMap(res);
    }

    @Override
    public BundleRevision getRevision() {
        return this.gen.bundleRevision;
    }

    @Override
    public BundleRevision getResource() {
        return this.gen.bundleRevision;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.gen == null ? 0 : this.gen.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleNameVersionCapability other = (BundleNameVersionCapability)obj;
        if (!this.gen.equals(other.gen)) {
            return false;
        }
        return this.namespace.equals(other.namespace);
    }

    public String toString() {
        return "BundleNameVersionCapability[nameSpace=" + this.namespace + ", attributes=" + this.getAttributes() + ", directives=" + this.getDirectives() + ", revision=" + this.getRevision() + "]";
    }
}

