/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.net.URLClassLoader;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.knopflerfish.framework.Alias;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Version;

public class FWProps {
    public static final String ALL_SIGNED_PROP = "org.knopflerfish.framework.all_signed";
    public static final String AUTOMANIFEST_PROP = "org.knopflerfish.framework.automanifest";
    public static final String AUTOMANIFEST_CONFIG_PROP = "org.knopflerfish.framework.automanifest.config";
    public static final String BUNDLESTORAGE_PROP = "org.knopflerfish.framework.bundlestorage";
    public static final String BUNDLESTORAGE_CHECKSIGNED_PROP = "org.knopflerfish.framework.bundlestorage.checksigned";
    public static final String PATCH_PROP = "org.knopflerfish.framework.patch";
    public static final String PATCH_CONFIGURL_PROP = "org.knopflerfish.framework.patch.configurl";
    public static final String PATCH_DUMPCLASSES_PROP = "org.knopflerfish.framework.patch.dumpclasses";
    public static final String PATCH_DUMPCLASSES_DIR_PROP = "org.knopflerfish.framework.patch.dumpclasses.dir";
    public static final String SERVICE_CONDITIONALPERMISSIONADMIN_PROP = "org.knopflerfish.framework.service.conditionalpermissionadmin";
    public static final String SERVICE_PERMISSIONADMIN_PROP = "org.knopflerfish.framework.service.permissionadmin";
    public static final String BUNDLETHREAD_ABORT = "org.knopflerfish.framework.bundlethread.abort";
    public static final String BUNDLETHREAD_TIMEOUT = "org.knopflerfish.framework.bundlethread.timeout";
    public static final String SYSTEM_PACKAGES_BASE_PROP = "org.knopflerfish.framework.system.packages.base";
    public static final String SYSTEM_PACKAGES_FILE_PROP = "org.knopflerfish.framework.system.packages.file";
    public static final String SYSTEM_PACKAGES_VERSION_PROP = "org.knopflerfish.framework.system.packages.version";
    public static final String IS_DOUBLECHECKED_LOCKING_SAFE_PROP = "org.knopflerfish.framework.is_doublechecked_locking_safe";
    public static final String LDAP_NOCACHE_PROP = "org.knopflerfish.framework.ldap.nocache";
    public static final String LISTENER_N_THREADS_PROP = "org.knopflerfish.framework.listener.n_threads";
    public static final String MAIN_CLASS_ACTIVATION_PROP = "org.knopflerfish.framework.main.class.activation";
    public static final String STRICTBOOTCLASSLOADING_PROP = "org.knopflerfish.framework.strictbootclassloading";
    public static final String VALIDATOR_PROP = "org.knopflerfish.framework.validator";
    public static final String SETCONTEXTCLASSLOADER_PROP = "org.knopflerfish.osgi.setcontextclassloader";
    public static final String REGISTERSERVICEURLHANDLER_PROP = "org.knopflerfish.osgi.registerserviceurlhandler";
    public static final String STARTLEVEL_USE_PROP = "org.knopflerfish.startlevel.use";
    public static final String STARTLEVEL_COMPAT_PROP = "org.knopflerfish.framework.startlevel.compat";
    public static final String READ_ONLY_PROP = "org.knopflerfish.framework.readonly";
    public static final String KEY_KEYS = "org.knopflerfish.framework.bundleprops.keys";
    public static final String RESOLVER_IMPLICIT_USES = "org.knopflerfish.framework.resolver.implicituses";
    public static final String RESOLVER_PREFER_SB = "org.knopflerfish.framework.resolver.prefersystembundle";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String NL = System.getProperty("line.separator");
    public boolean STRICTBOOTCLASSLOADING;
    protected Hashtable<String, String> props = new Hashtable();
    protected Hashtable<String, String> props_default = new Hashtable();
    public boolean UNREGISTERSERVICE_VALID_DURING_UNREGISTERING = true;
    public boolean SETCONTEXTCLASSLOADER = false;
    public boolean REGISTERSERVICEURLHANDLER = true;
    public static int javaVersionMajor = -1;
    public static int javaVersionMinor = -1;
    public static int javaVersionMicro = -1;
    public static int androidApiLevel = -1;
    private static final String FRAMEWORK_EXECUTIONENVIRONMENT = "org.osgi.framework.executionenvironment";
    public boolean isDoubleCheckedLockingSafe;

    public FWProps(Map<String, String> initProps, FrameworkContext fwCtx) {
        this.props.putAll(initProps);
        fwCtx.debug = new Debug(this);
        this.initProperties(fwCtx);
        this.initKFProperties();
        this.SETCONTEXTCLASSLOADER = this.getBooleanProperty(SETCONTEXTCLASSLOADER_PROP);
        this.REGISTERSERVICEURLHANDLER = this.getBooleanProperty(REGISTERSERVICEURLHANDLER_PROP);
        this.STRICTBOOTCLASSLOADING = this.getBooleanProperty(STRICTBOOTCLASSLOADING_PROP);
        this.isDoubleCheckedLockingSafe = this.getBooleanProperty(IS_DOUBLECHECKED_LOCKING_SAFE_PROP);
    }

    public boolean getBooleanProperty(String key) {
        String v = this.getProperty(key);
        if (v != null) {
            return TRUE.equalsIgnoreCase(v);
        }
        return false;
    }

    public String getProperty(String key) {
        if (KEY_KEYS.equals(key)) {
            return this.makeKeys();
        }
        String v = this.props.get(key);
        if (v == null && (v = System.getProperty(key)) == null) {
            return this.props_default.get(key);
        }
        return v.trim();
    }

    public void setPropertyDefault(String key, String val) {
        if (!this.props.containsKey(key)) {
            this.props_default.put(key, val);
        }
    }

    public void setPropertyIfNotSet(String key, String val) {
        if (!this.props.containsKey(key)) {
            this.props.put(key, System.getProperty(key, val));
        }
    }

    public Dictionary<String, String> getProperties() {
        Hashtable<String, String> p = new Hashtable<String, String>(this.props_default);
        Properties sysProps = System.getProperties();
        p.putAll(sysProps);
        p.putAll(this.props);
        p.put(KEY_KEYS, this.makeKeys());
        return p;
    }

    protected String makeKeys() {
        StringBuffer sb = new StringBuffer();
        for (String string : this.props.keySet()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(string.toString());
        }
        for (String string : this.props_default.keySet()) {
            sb.append(',');
            sb.append(string.toString());
        }
        return sb.toString();
    }

    protected void initProperties(FrameworkContext fwCtx) {
        this.setPropertyIfNotSet("org.osgi.framework.bootdelegation", "");
        this.setPropertyIfNotSet("org.osgi.framework.bsnversion", "managed");
        this.setPropertyIfNotSet("org.osgi.framework.bundle.parent", "boot");
        this.setPropertyIfNotSet("org.osgi.framework.command.execpermission", "");
        if (!this.props.containsKey(FRAMEWORK_EXECUTIONENVIRONMENT)) {
            StringBuffer ee = new StringBuffer();
            ee.append("OSGi/Minimum-1.0");
            ee.append(",OSGi/Minimum-1.1");
            ee.append(",OSGi/Minimum-1.2");
            if (javaVersionMajor > 0) {
                int maxMinor;
                if (javaVersionMajor >= 9) {
                    ee.append(",JavaSE-").append(javaVersionMajor);
                }
                for (int i = maxMinor = javaVersionMajor == 1 ? javaVersionMinor : 8; i > 1; --i) {
                    ee.append(i > 5 ? ",JavaSE-1." : ",J2SE-1.");
                    ee.append(i);
                }
            } else if (androidApiLevel > 0) {
                for (int i = androidApiLevel; i >= 12; --i) {
                    ee.append(",Android-" + i);
                }
            }
            this.props.put(FRAMEWORK_EXECUTIONENVIRONMENT, ee.toString());
        }
        this.setPropertyIfNotSet("org.osgi.framework.system.capabilities", "");
        this.setPropertyIfNotSet("org.osgi.framework.system.capabilities.extra", "");
        this.setPropertyIfNotSet("org.osgi.framework.language", Locale.getDefault().getLanguage());
        this.setPropertyIfNotSet("org.osgi.framework.library.extensions", "");
        this.setPropertyIfNotSet("org.osgi.framework.os.name", Alias.unifyOsName(System.getProperty("os.name")));
        if (!this.props.containsKey("org.osgi.framework.os.version")) {
            Version osVersion;
            String ver = System.getProperty("os.version");
            int maj = 0;
            int min = 0;
            int mic = 0;
            String qual = null;
            if (ver != null) {
                try {
                    StringTokenizer st = new StringTokenizer(ver.trim(), ".");
                    maj = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        qual = st.nextToken();
                        min = Integer.parseInt(qual);
                        qual = null;
                        if (st.hasMoreTokens()) {
                            qual = st.nextToken();
                            mic = Integer.parseInt(qual);
                            qual = null;
                            if (st.hasMoreTokens()) {
                                qual = st.nextToken();
                            }
                        }
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            try {
                osVersion = new Version(maj, min, mic, qual);
            }
            catch (IllegalArgumentException skip) {
                osVersion = new Version(maj, min, mic, null);
            }
            this.props.put("org.osgi.framework.os.version", osVersion.toString());
        }
        this.setPropertyIfNotSet("org.osgi.framework.processor", Alias.unifyProcessor(System.getProperty("os.arch")));
        this.setPropertyIfNotSet("org.osgi.framework.security", "");
        this.setPropertyIfNotSet("org.osgi.framework.startlevel.beginning", "1");
        this.setPropertyIfNotSet("org.osgi.framework.storage", "fwdir");
        this.setPropertyIfNotSet("org.osgi.framework.storage.clean", "");
        this.setPropertyIfNotSet("org.osgi.framework.system.packages", "");
        this.setPropertyIfNotSet("org.osgi.framework.system.packages.extra", "");
        this.setPropertyIfNotSet("org.osgi.framework.trust.repositories", "");
        this.setPropertyIfNotSet("org.osgi.framework.windowsystem", "");
        this.props.put("org.osgi.framework.version", Util.readFrameworkVersion());
        this.props.put("org.osgi.framework.vendor", "Knopflerfish");
        this.props.put("org.osgi.supports.framework.requirebundle", TRUE);
        this.props.put("org.osgi.supports.framework.fragment", TRUE);
        this.setPropertyIfNotSet("org.osgi.supports.framework.extension", this.getClass().getClassLoader() instanceof URLClassLoader && fwCtx.id == 0 ? TRUE : FALSE);
        this.setPropertyIfNotSet("org.osgi.supports.bootclasspath.extension", FALSE);
        if (this.getBooleanProperty("org.osgi.supports.bootclasspath.extension") && (!(this.getClass().getClassLoader() instanceof URLClassLoader) || fwCtx.id != 1)) {
            this.props.put("org.osgi.supports.bootclasspath.extension", FALSE);
        }
    }

    protected void initKFProperties() {
        this.setPropertyDefault(ALL_SIGNED_PROP, FALSE);
        this.setPropertyDefault(AUTOMANIFEST_PROP, FALSE);
        this.setPropertyDefault(AUTOMANIFEST_CONFIG_PROP, "!!/automanifest.props");
        this.setPropertyDefault(BUNDLESTORAGE_PROP, androidApiLevel >= 0 ? "dex" : "file");
        this.setPropertyDefault(BUNDLESTORAGE_CHECKSIGNED_PROP, TRUE);
        this.setPropertyDefault(PATCH_PROP, FALSE);
        this.setPropertyDefault(PATCH_CONFIGURL_PROP, "!!/patches.props");
        this.setPropertyDefault(PATCH_DUMPCLASSES_PROP, FALSE);
        this.setPropertyDefault(PATCH_DUMPCLASSES_DIR_PROP, "patchedclasses");
        this.setPropertyDefault(SERVICE_CONDITIONALPERMISSIONADMIN_PROP, TRUE);
        this.setPropertyDefault(SERVICE_PERMISSIONADMIN_PROP, TRUE);
        this.setPropertyDefault(SYSTEM_PACKAGES_BASE_PROP, "");
        this.setPropertyDefault(SYSTEM_PACKAGES_FILE_PROP, "");
        StringBuffer pver = new StringBuffer();
        if (javaVersionMajor >= 0) {
            pver.append(javaVersionMajor);
            if (javaVersionMinor >= 0) {
                pver.append('.').append(javaVersionMinor);
            }
        } else {
            pver.append(0);
        }
        this.setPropertyDefault(SYSTEM_PACKAGES_VERSION_PROP, pver.toString());
        this.setPropertyDefault(IS_DOUBLECHECKED_LOCKING_SAFE_PROP, TRUE);
        this.setPropertyDefault(LDAP_NOCACHE_PROP, FALSE);
        this.setPropertyDefault(MAIN_CLASS_ACTIVATION_PROP, "");
        this.setPropertyDefault(STRICTBOOTCLASSLOADING_PROP, FALSE);
        this.setPropertyDefault(VALIDATOR_PROP, this.getProperty("org.osgi.framework.trust.repositories").length() > 0 ? "JKSValidator" : "none");
        this.setPropertyDefault(SETCONTEXTCLASSLOADER_PROP, FALSE);
        this.setPropertyDefault(REGISTERSERVICEURLHANDLER_PROP, TRUE);
        this.setPropertyDefault(STARTLEVEL_COMPAT_PROP, FALSE);
        this.setPropertyDefault(STARTLEVEL_USE_PROP, TRUE);
        this.setPropertyDefault(READ_ONLY_PROP, FALSE);
        this.setPropertyDefault(RESOLVER_IMPLICIT_USES, FALSE);
        this.setPropertyDefault(RESOLVER_PREFER_SB, FALSE);
    }

    Map<String, Object> getFWProperties() {
        return new HashMap<String, Object>(this.props);
    }

    static {
        try {
            androidApiLevel = Class.forName("android.os.Build$VERSION").getField("SDK_INT").getInt(null);
        }
        catch (UnsatisfiedLinkError strange) {
            androidApiLevel = 12;
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (androidApiLevel == -1) {
            String javaVersion = System.getProperty("java.specification.version");
            if (javaVersion == null || javaVersion.length() == 0) {
                javaVersion = System.getProperty("java.version");
            }
            if (null != javaVersion) {
                int endPos;
                int startPos = 0;
                int max = javaVersion.length();
                for (endPos = 0; endPos < max && Character.isDigit(javaVersion.charAt(endPos)); ++endPos) {
                }
                if (startPos < endPos) {
                    try {
                        javaVersionMajor = Integer.parseInt(javaVersion.substring(startPos, endPos));
                        for (endPos = startPos = endPos + 1; endPos < max && Character.isDigit(javaVersion.charAt(endPos)); ++endPos) {
                        }
                        if (startPos < endPos) {
                            javaVersionMinor = Integer.parseInt(javaVersion.substring(startPos, endPos));
                            for (endPos = startPos = endPos + 1; endPos < max && Character.isDigit(javaVersion.charAt(endPos)); ++endPos) {
                            }
                            if (startPos < endPos) {
                                javaVersionMicro = Integer.parseInt(javaVersion.substring(startPos, endPos));
                            }
                        }
                    }
                    catch (NumberFormatException _nfe) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

