/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.modules;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ForwardingCollection;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.PackageMatcher;
import com.tngtech.archunit.library.modules.AnnotationDescriptor;
import com.tngtech.archunit.library.modules.ArchModule;
import com.tngtech.archunit.library.modules.ModuleDependency;
import com.tngtech.archunit.thirdparty.com.google.common.base.Functions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Multimaps;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
public final class ArchModules<DESCRIPTOR extends ArchModule.Descriptor>
extends ForwardingCollection<ArchModule<DESCRIPTOR>> {
    private final Map<ArchModule.Identifier, ArchModule<DESCRIPTOR>> modulesByIdentifier;
    private final Map<String, ArchModule<DESCRIPTOR>> modulesByName;

    private ArchModules(Set<ArchModule<DESCRIPTOR>> modules) {
        this.modulesByIdentifier = ArchModules.groupBy(modules, ArchModule::getIdentifier, "identifier");
        this.modulesByName = ArchModules.groupBy(modules, ArchModule::getName, "name");
        HashMultimap moduleDependenciesByOrigin = HashMultimap.create();
        modules.forEach(it -> moduleDependenciesByOrigin.putAll(it.getIdentifier(), this.createModuleDependencies((ArchModule<DESCRIPTOR>)it, modules)));
        HashMultimap moduleDependenciesByTarget = HashMultimap.create();
        moduleDependenciesByOrigin.values().forEach(moduleDependency -> moduleDependenciesByTarget.put(moduleDependency.getTarget().getIdentifier(), moduleDependency));
        modules.forEach(it -> it.setModuleDependencies(moduleDependenciesByOrigin.get(it.getIdentifier()), moduleDependenciesByTarget.get(it.getIdentifier())));
    }

    private static <D extends ArchModule.Descriptor, KEY> Map<KEY, ArchModule<D>> groupBy(Set<ArchModule<D>> modules, Function<ArchModule<D>, KEY> getKey, String keyName) {
        Map modulesByKey = modules.stream().collect(Multimaps.toMultimap(getKey, Function.identity(), HashMultimap::create)).asMap();
        SortedSet duplicateKeys = modulesByKey.entrySet().stream().filter(it -> ((Collection)it.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toCollection(TreeSet::new));
        if (!duplicateKeys.isEmpty()) {
            throw new IllegalArgumentException(String.format("Found multiple modules with the same %s: %s", keyName, duplicateKeys));
        }
        return modulesByKey.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (ArchModule)Iterables.getOnlyElement((Iterable)entry.getValue())));
    }

    private ImmutableSet<ModuleDependency<DESCRIPTOR>> createModuleDependencies(ArchModule<DESCRIPTOR> origin, Set<ArchModule<DESCRIPTOR>> modules) {
        ImmutableSet.Builder moduleDependencies = ImmutableSet.builder();
        for (ArchModule archModule : Sets.difference(modules, Collections.singleton(origin))) {
            ModuleDependency.tryCreate(origin, archModule).ifPresent(moduleDependencies::add);
        }
        return moduleDependencies.build();
    }

    @Override
    protected Collection<ArchModule<DESCRIPTOR>> delegate() {
        return this.modulesByIdentifier.values();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public ArchModule<DESCRIPTOR> getByIdentifier(String ... identifier) {
        return this.tryGetByIdentifier(identifier).orElseThrow(() -> new IllegalArgumentException(String.format("There is no %s with identifier %s", ArchModule.class.getSimpleName(), Arrays.toString(identifier))));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public Optional<ArchModule<DESCRIPTOR>> tryGetByIdentifier(String ... identifier) {
        return Optional.ofNullable(this.modulesByIdentifier.get(ArchModule.Identifier.from(identifier)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public ArchModule<DESCRIPTOR> getByName(String name) {
        return this.tryGetByName(name).orElseThrow(() -> new IllegalArgumentException(String.format("There is no %s with name %s", ArchModule.class.getSimpleName(), name)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public Optional<ArchModule<DESCRIPTOR>> tryGetByName(String name) {
        return Optional.ofNullable(this.modulesByName.get(name));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public Set<String> getNames() {
        return this.modulesByName.keySet().stream().map(Functions.toStringFunction()).collect(ImmutableSet.toImmutableSet());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static Creator defineByPackages(String packageIdentifier) {
        return ArchModules.defineBy(ArchModules.identifierByPackage(packageIdentifier));
    }

    private static IdentifierAssociation identifierByPackage(String packageIdentifier) {
        PackageMatcher packageMatcher = PackageMatcher.of(packageIdentifier);
        return javaClass -> {
            Optional<PackageMatcher.Result> result = packageMatcher.match(javaClass.getPackageName());
            return result.map(PackageMatcher.TO_GROUPS).map(ArchModule.Identifier::from).orElse(ArchModule.Identifier.ignore());
        };
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static CreatorByRootClass defineByRootClasses(Predicate<? super JavaClass> rootClassPredicate) {
        return CreatorByRootClass.from(rootClassPredicate);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static <A extends Annotation> Creator.WithGenericDescriptor<AnnotationDescriptor<A>> defineByAnnotation(Class<A> annotationType) {
        return ArchModules.defineByAnnotation(annotationType, input -> {
            try {
                return (String)input.annotationType().getMethod("name", new Class[0]).invoke(input, new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                String message = String.format("Could not invoke @%s.name() -> Supplied annotation must provide a method 'String name()'. Otherwise use defineByAnnotation(annotationType, nameFunction).", input.annotationType().getSimpleName());
                throw new IllegalArgumentException(message, e);
            }
        });
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static <A extends Annotation> Creator.WithGenericDescriptor<AnnotationDescriptor<A>> defineByAnnotation(Class<A> annotationType, Function<A, String> nameFunction) {
        return ArchModules.defineByRootClasses(it -> it.isAnnotatedWith(annotationType)).describeModuleByRootClass((__, rootClass) -> {
            Object annotation = rootClass.getAnnotationOfType(annotationType);
            return new AnnotationDescriptor((String)nameFunction.apply(annotation), annotation);
        });
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static Creator defineBy(IdentifierAssociation identifierFunction) {
        return new Creator(Preconditions.checkNotNull(identifierFunction));
    }

    @FunctionalInterface
    @PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
    public static interface IdentifierAssociation {
        default public void init(Collection<JavaClass> allClasses) {
        }

        public ArchModule.Identifier associate(JavaClass var1);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static class Creator {
        private final IdentifierAssociation identifierAssociation;
        private final Function<ArchModule.Identifier, String> deriveNameFunction;
        private static final Function<ArchModule.Identifier, String> DEFAULT_NAMING_STRATEGY = Creator::joinIdentifier;

        private Creator(IdentifierAssociation identifierAssociation) {
            this(identifierAssociation, DEFAULT_NAMING_STRATEGY);
        }

        private Creator(IdentifierAssociation identifierAssociation, Function<ArchModule.Identifier, String> deriveNameFunction) {
            this.identifierAssociation = Preconditions.checkNotNull(identifierAssociation);
            this.deriveNameFunction = Preconditions.checkNotNull(deriveNameFunction);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public Creator deriveNameFromPattern(String namingPattern) {
            return new Creator(this.identifierAssociation, identifier -> {
                String result = namingPattern.replace("$@", Creator.joinIdentifier(identifier));
                for (int i = 1; i <= identifier.getNumberOfParts(); ++i) {
                    result = result.replace("$" + i, identifier.getPart(i)).replace("${" + i + "}", identifier.getPart(i));
                }
                return result;
            });
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public <D extends ArchModule.Descriptor> WithGenericDescriptor<D> describeBy(DescriptorCreator<D> descriptorCreator) {
            return new WithGenericDescriptor(this.identifierAssociation, descriptorCreator);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public ArchModules<?> modularize(JavaClasses classes) {
            return this.describeBy((identifier, __) -> ArchModule.Descriptor.create(this.deriveNameFunction.apply(identifier))).modularize(classes);
        }

        private static String joinIdentifier(ArchModule.Identifier identifier) {
            return Joiner.on(":").join(identifier);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public static final class WithGenericDescriptor<DESCRIPTOR extends ArchModule.Descriptor> {
            private final IdentifierAssociation identifierAssociation;
            private final DescriptorCreator<DESCRIPTOR> descriptorCreator;

            private WithGenericDescriptor(IdentifierAssociation identifierAssociation, DescriptorCreator<DESCRIPTOR> descriptorCreator) {
                this.identifierAssociation = Preconditions.checkNotNull(identifierAssociation);
                this.descriptorCreator = Preconditions.checkNotNull(descriptorCreator);
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
            public ArchModules<DESCRIPTOR> modularize(JavaClasses classes) {
                SetMultimap<ArchModule.Identifier, JavaClass> classesByIdentifier = this.groupClassesByIdentifier(classes);
                HashSet modules = new HashSet();
                Multimaps.asMap(classesByIdentifier).forEach((identifier, containedClasses) -> {
                    DESCRIPTOR descriptor = this.descriptorCreator.create((ArchModule.Identifier)identifier, (Set<JavaClass>)containedClasses);
                    modules.add(new ArchModule<DESCRIPTOR>((ArchModule.Identifier)identifier, descriptor, (Set<JavaClass>)containedClasses));
                });
                return new ArchModules(modules);
            }

            private SetMultimap<ArchModule.Identifier, JavaClass> groupClassesByIdentifier(JavaClasses classes) {
                this.identifierAssociation.init(classes);
                HashMultimap<ArchModule.Identifier, JavaClass> classesByIdentifier = HashMultimap.create();
                for (JavaClass javaClass : classes) {
                    ArchModule.Identifier identifier = this.identifierAssociation.associate(javaClass);
                    if (!identifier.shouldBeConsidered()) continue;
                    classesByIdentifier.put(identifier, javaClass);
                }
                return classesByIdentifier;
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static class CreatorByRootClass
    extends Creator {
        private final RootClassIdentifierAssociation identifierAssociation;

        private CreatorByRootClass(RootClassIdentifierAssociation identifierAssociation) {
            super((IdentifierAssociation)identifierAssociation);
            this.identifierAssociation = identifierAssociation;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public <D extends ArchModule.Descriptor> Creator.WithGenericDescriptor<D> describeModuleByRootClass(RootClassDescriptorCreator<D> descriptorCreator) {
            return this.describeBy((identifier, __) -> descriptorCreator.create(identifier, this.identifierAssociation.getRootClassOf(identifier)));
        }

        static CreatorByRootClass from(Predicate<? super JavaClass> rootClassPredicate) {
            return new CreatorByRootClass(new RootClassIdentifierAssociation(rootClassPredicate));
        }

        private static class RootClassIdentifierAssociation
        implements IdentifierAssociation {
            private final Map<String, ArchModule.Identifier> packageToIdentifier = new HashMap<String, ArchModule.Identifier>();
            private final Map<ArchModule.Identifier, JavaClass> identifierToRootClass = new HashMap<ArchModule.Identifier, JavaClass>();
            private final Predicate<? super JavaClass> rootClassPredicate;

            private RootClassIdentifierAssociation(Predicate<? super JavaClass> rootClassPredicate) {
                this.rootClassPredicate = rootClassPredicate;
            }

            @Override
            public void init(Collection<JavaClass> allClasses) {
                allClasses.stream().filter(this.rootClassPredicate).forEach(rootClass -> {
                    this.packageToIdentifier.keySet().forEach(pkg -> {
                        if (this.packagesOverlap((String)pkg, rootClass.getPackageName())) {
                            throw new IllegalArgumentException(String.format("modules would overlap in '%s' and '%s'", pkg, rootClass.getPackageName()));
                        }
                    });
                    ArchModule.Identifier identifier = ArchModule.Identifier.from(rootClass.getPackageName());
                    this.packageToIdentifier.put(rootClass.getPackageName(), identifier);
                    this.identifierToRootClass.put(identifier, (JavaClass)rootClass);
                });
            }

            private boolean packagesOverlap(String firstPackageName, String secondPackageName) {
                return this.packageContains(firstPackageName, secondPackageName) || this.packageContains(secondPackageName, firstPackageName);
            }

            private boolean packageContains(String parentPackage, String childPackage) {
                return childPackage.equals(parentPackage) || childPackage.startsWith(parentPackage + ".");
            }

            @Override
            public ArchModule.Identifier associate(JavaClass javaClass) {
                return this.packageToIdentifier.entrySet().stream().filter(it -> this.packageContains((String)it.getKey(), javaClass.getPackageName())).findFirst().map(Map.Entry::getValue).orElse(ArchModule.Identifier.ignore());
            }

            JavaClass getRootClassOf(ArchModule.Identifier identifier) {
                return this.identifierToRootClass.get(identifier);
            }
        }
    }

    @FunctionalInterface
    @PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
    public static interface RootClassDescriptorCreator<DESCRIPTOR extends ArchModule.Descriptor> {
        public DESCRIPTOR create(ArchModule.Identifier var1, JavaClass var2);
    }

    @FunctionalInterface
    @PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
    public static interface DescriptorCreator<DESCRIPTOR extends ArchModule.Descriptor> {
        public DESCRIPTOR create(ArchModule.Identifier var1, Set<JavaClass> var2);
    }
}

