/*
 * Decompiled with CFR 0.152.
 */
package org.dpolivaev.mnemonicsetter;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.dpolivaev.mnemonicsetter.ButtonNameMnemonicHolder;
import org.dpolivaev.mnemonicsetter.INameMnemonicHolder;
import org.dpolivaev.mnemonicsetter.ItemMnemonicSetter;
import org.dpolivaev.mnemonicsetter.MenuItemMnemonicHolder;
import org.dpolivaev.mnemonicsetter.UsedAltAcceleratorsFinder;

public class MnemonicSetter
implements PopupMenuListener {
    private static final boolean IS_MAC_OS = System.getProperty("os.name").startsWith("Mac OS");
    public static final MnemonicSetter INSTANCE = new MnemonicSetter();

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        Container popupMenu = (Container)e.getSource();
        this.setComponentMnemonics(popupMenu);
    }

    public void setComponentMnemonics(Container ... containers) {
        if (IS_MAC_OS) {
            return;
        }
        int componentCount = 0;
        for (Container container : containers) {
            componentCount += this.countComponents(container);
        }
        HashSet<Integer> keyCodesUsedInMenus = new HashSet<Integer>();
        ArrayList<INameMnemonicHolder> mnemonicHolders = new ArrayList<INameMnemonicHolder>(componentCount);
        for (Container container : containers) {
            this.addComponents(container, keyCodesUsedInMenus, mnemonicHolders);
        }
        ItemMnemonicSetter mnemonicSetter = ItemMnemonicSetter.of(mnemonicHolders).notUsing(keyCodesUsedInMenus);
        mnemonicSetter.setMnemonics();
    }

    private void addComponents(Container container, Collection<Integer> keyCodesUsedInMenus, ArrayList<INameMnemonicHolder> mnemonicHolders) {
        Component[] components;
        if (container instanceof JMenuBar) {
            Collection<Integer> keyCodesUsedInMenu = UsedAltAcceleratorsFinder.INSTANCE.findUsedKeyCodes((JMenuBar)container);
            keyCodesUsedInMenus.addAll(keyCodesUsedInMenu);
        }
        for (Component component : components = container.getComponents()) {
            if (component instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)component;
                mnemonicHolders.add(new MenuItemMnemonicHolder(item));
                continue;
            }
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                mnemonicHolders.add(new ButtonNameMnemonicHolder(button));
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.addComponents((Container)component, keyCodesUsedInMenus, mnemonicHolders);
        }
    }

    private int countComponents(Container container) {
        Component[] components;
        if (container instanceof JMenuBar) {
            return container.getComponentCount();
        }
        int count = 0;
        for (Component component : components = container.getComponents()) {
            if (component instanceof JMenuItem || component instanceof AbstractButton) {
                ++count;
                continue;
            }
            if (!(component instanceof Container)) continue;
            count += this.countComponents((Container)component);
        }
        return count;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

