/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.WindowConfigurationStorage;
import org.freeplane.core.resources.components.GrabKeyDialog;
import org.freeplane.core.ui.components.ToolbarLayout;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconDescription;
import org.freeplane.features.icon.factory.IconFactory;
import org.freeplane.features.icon.mindmapmode.FastAccessableIcons;

public class IconSelectionPopupDialog
extends JDialog
implements MouseListener {
    private static final String WINDOW_CONFIG_PROPERTY = "icon_selection_window_configuration";
    private static int BORDER_THICKNESS = 2;
    private static final Border USUAL = BorderFactory.createEmptyBorder(BORDER_THICKNESS, BORDER_THICKNESS, BORDER_THICKNESS, BORDER_THICKNESS);
    private static final Border HIGHLIGHTED = BorderFactory.createLineBorder(Color.RED, BORDER_THICKNESS);
    private static final long serialVersionUID = 1L;
    private static String lastSearchText = "";
    private final JLabel descriptionLabel;
    private final List<JLabel> iconLabels;
    private final JPanel iconPanel = new JPanel();
    private final List<? extends IconDescription> icons;
    private final JTextField filterTextField;
    private int mModifiers;
    private final int numOfIcons;
    private int selectedIconIndex;
    private JLabel selected;
    private Timer filterTimer;
    private ActionListener listener;
    private JCheckBox closeAfterSelection;
    private Box statusPanel;
    private final MouseListener focusRequester = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            e.getComponent().requestFocusInWindow();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            IconSelectionPopupDialog.this.filterTextField.requestFocusInWindow();
        }
    };
    private final ActionListener actionPanelActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IconSelectionPopupDialog.this.closeAfterSelection != null && IconSelectionPopupDialog.this.closeAfterSelection.isSelected()) {
                IconSelectionPopupDialog.this.dispose();
            }
        }
    };

    public IconSelectionPopupDialog(Frame frame, List<? extends IconDescription> icons) {
        super(frame, TextUtils.getText("select_icon"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.icons = icons;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                IconSelectionPopupDialog.this.close();
            }
        });
        this.numOfIcons = icons.size();
        int singleIconSize = (int)((IconFactory.DEFAULT_UI_ICON_HEIGHT.toBaseUnits() + 0.5) * 1.1);
        int xDimension = Math.min(20, (int)Math.ceil(Math.sqrt(this.numOfIcons)) * 16 / 9);
        ToolbarLayout layout = ToolbarLayout.vertical();
        layout.setMaximumWidth(Math.min(singleIconSize * xDimension, UITools.getScreenBounds((GraphicsConfiguration)frame.getGraphicsConfiguration()).width * 4 / 5));
        this.iconPanel.setLayout(layout);
        this.iconLabels = new ArrayList<JLabel>(this.numOfIcons);
        for (int i = 0; i < this.numOfIcons; ++i) {
            IconDescription icon = icons.get(i);
            JLabel label = new JLabel(icon.getActionIcon());
            label.putClientProperty(IconDescription.class, icon);
            this.iconLabels.add(label);
            this.iconPanel.add(label);
            label.setBorder(USUAL);
            label.addMouseListener(this);
        }
        Dimension preferredSize = this.iconPanel.getPreferredSize();
        JScrollPane scrollPane = new JScrollPane(this.iconPanel, 22, 31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(singleIconSize);
        scrollPane.setPreferredSize(new Dimension(preferredSize.width, preferredSize.width / 2));
        this.filterTextField = this.setupFilterTextField_and_KeyListener();
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                IconSelectionPopupDialog.this.filterTextField.requestFocusInWindow();
                IconSelectionPopupDialog.this.removeWindowFocusListener(this);
            }
        });
        contentPane.add((Component)this.filterTextField, "North");
        contentPane.add((Component)scrollPane, "Center");
        this.descriptionLabel = new JLabel(" ");
        this.statusPanel = Box.createHorizontalBox();
        this.statusPanel.add(this.descriptionLabel);
        this.statusPanel.add(Box.createHorizontalGlue());
        contentPane.add((Component)this.statusPanel, "South");
        this.selected = this.iconLabels.get(0);
        this.highlightSelected();
        WindowConfigurationStorage windowConfigurationStorage = new WindowConfigurationStorage(WINDOW_CONFIG_PROPERTY);
        windowConfigurationStorage.setBounds(this);
        this.filterTimer = new Timer(300, this::filterIcons);
        this.filterTimer.setRepeats(false);
    }

    private JTextField setupFilterTextField_and_KeyListener() {
        JTextField filterTextField = new JTextField();
        filterTextField.setText(lastSearchText);
        filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                IconSelectionPopupDialog.this.filterIconsLater();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                IconSelectionPopupDialog.this.filterIconsLater();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                IconSelectionPopupDialog.this.filterIconsLater();
            }
        });
        filterTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                IconSelectionPopupDialog.this.processKeyEvent(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        return filterTextField;
    }

    private void filterIconsLater() {
        this.filterTimer.restart();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void filterIcons(ActionEvent e) {
        String filterText = this.filterTextField.getText().toLowerCase();
        if (filterText.trim().length() > 0) {
            Pattern regex;
            if (filterText.startsWith("/")) {
                if (filterText.trim().length() < 2) return;
                try {
                    regex = Pattern.compile(filterText.substring(1).trim(), 2);
                }
                catch (PatternSyntaxException pse) {
                    return;
                }
            } else {
                regex = null;
            }
            for (JLabel label : this.iconLabels) {
                boolean matches = false;
                for (String tag : this.getTags(label)) {
                    if (regex != null) {
                        matches = regex.matcher(tag).matches();
                    } else if (filterText.contains(" ")) {
                        matches = true;
                        StringTokenizer tokenizer = new StringTokenizer(filterText);
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            if (matches = matches && tag.contains(token)) continue;
                            break;
                        }
                    } else {
                        matches = tag.contains(filterText);
                    }
                    if (matches) break;
                }
                label.setVisible(matches);
            }
        } else {
            for (Component component : this.iconPanel.getComponents()) {
                component.setVisible(true);
            }
        }
        SwingUtilities.invokeLater(this::adjustSelection);
    }

    private void adjustSelection() {
        if (!this.iconPanel.isValid()) {
            SwingUtilities.invokeLater(this::adjustSelection);
            return;
        }
        if (this.selected == null || !this.selected.isVisible()) {
            this.select(new Point(0, 0));
        } else {
            this.scrollToSelected();
        }
    }

    private String[] getTags(JLabel label) {
        IconDescription iconDescription = (IconDescription)label.getClientProperty(IconDescription.class);
        String iconLabel = iconDescription.getTranslatedDescription();
        if (iconLabel.startsWith("icon_")) {
            iconLabel = iconLabel.substring(5);
        }
        return new String[]{iconLabel.toLowerCase(), iconDescription.getFile().toLowerCase()};
    }

    private void addIcon(int pModifiers) {
        this.addIcon(this.iconLabels.indexOf(this.selected), pModifiers);
    }

    private void addIcon(int iconIndex, int pModifiers) {
        this.selectedIconIndex = iconIndex;
        this.mModifiers = pModifiers;
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, this.selectedIconIndex, "", System.currentTimeMillis(), this.mModifiers));
            if (this.closeAfterSelection.isSelected()) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private int findIndex(Point location) {
        for (int i = 0; i < this.iconLabels.size(); ++i) {
            JLabel label = this.iconLabels.get(i);
            if (!label.getBounds().contains(location)) continue;
            return i;
        }
        return -1;
    }

    private void close() {
        this.selectedIconIndex = -1;
        this.mModifiers = 0;
        this.dispose();
    }

    private void cursorDown() {
        if (this.selected == null) {
            return;
        }
        Point newPosition = new Point(this.selected.getX(), this.selected.getY() + this.selected.getWidth() + 1);
        int newIndex = this.findIndex(newPosition);
        if (newIndex >= 0) {
            this.select(newIndex);
        }
    }

    private void cursorLeft() {
        if (this.selected == null) {
            return;
        }
        Point newPosition = new Point(this.selected.getX() - 1, this.selected.getY());
        int newIndex = this.findIndex(newPosition);
        if (newIndex >= 0) {
            this.select(newIndex);
        }
    }

    private void cursorRight() {
        if (this.selected == null) {
            return;
        }
        Point newPosition = new Point(this.selected.getX() + this.selected.getHeight() + 1, this.selected.getY());
        int newIndex = this.findIndex(newPosition);
        if (newIndex >= 0) {
            this.select(newIndex);
        }
    }

    private void cursorUp() {
        if (this.selected == null) {
            return;
        }
        Point newPosition = new Point(this.selected.getX(), this.selected.getY() - 1);
        int newIndex = this.findIndex(newPosition);
        if (newIndex >= 0) {
            this.select(newIndex);
        }
    }

    public KeyStroke getKeyStroke(String keystrokeResourceName) {
        String keyStrokeDescription = ResourceController.getResourceController().getProperty(keystrokeResourceName);
        return UITools.getKeyStroke(keyStrokeDescription);
    }

    private int findIndexByKeyEvent(KeyEvent keyEvent) {
        for (int i = 0; i < this.icons.size(); ++i) {
            IconDescription info = this.icons.get(i);
            KeyStroke iconKeyStroke = this.getKeyStroke(info.getShortcutKey());
            if (iconKeyStroke == null || (keyEvent.getKeyCode() != iconKeyStroke.getKeyCode() || keyEvent.getKeyCode() == 0 || (iconKeyStroke.getModifiers() & 1) != (keyEvent.getModifiers() & 1)) && (keyEvent.getKeyChar() != iconKeyStroke.getKeyChar() || keyEvent.getKeyChar() == '\u0000' || keyEvent.getKeyChar() == '\uffff')) continue;
            return i;
        }
        return -1;
    }

    public int getModifiers() {
        int m = this.mModifiers;
        if ((this.mModifiers & 0x41) != 0) {
            m |= 1;
        }
        if ((this.mModifiers & 0x82) != 0) {
            m |= 2;
        }
        if ((this.mModifiers & 0x104) != 0) {
            m |= 4;
        }
        if ((this.mModifiers & 0x208) != 0) {
            m |= 8;
        }
        return m;
    }

    public int getIconIndex() {
        return this.selectedIconIndex;
    }

    private void highlightSelected() {
        this.selected.setBorder(HIGHLIGHTED);
        this.scrollToSelected();
    }

    private void scrollToSelected() {
        if (this.selected != null) {
            this.selected.scrollRectToVisible(new Rectangle(0, 0, this.selected.getWidth(), this.selected.getHeight()));
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        int index;
        boolean areModifiersDown = keyEvent.isControlDown() || keyEvent.isMetaDown();
        switch (keyEvent.getKeyCode()) {
            case 39: 
            case 227: {
                this.cursorRight();
                return;
            }
            case 37: 
            case 226: {
                this.cursorLeft();
                return;
            }
            case 40: 
            case 225: {
                this.cursorDown();
                return;
            }
            case 38: 
            case 224: {
                this.cursorUp();
                return;
            }
            case 27: {
                keyEvent.consume();
                this.close();
                return;
            }
            case 10: {
                keyEvent.consume();
                this.addIcon(keyEvent.getModifiers());
                if (this.listener != null && this.closeAfterSelection.isSelected()) {
                    this.dispose();
                }
                return;
            }
        }
        if (areModifiersDown && (index = this.findIndexByKeyEvent(keyEvent)) != -1) {
            keyEvent.consume();
            this.addIcon(index, keyEvent.getModifiers());
            if (this.listener != null && this.closeAfterSelection.isSelected()) {
                this.dispose();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown()) {
            this.changeKeystroke();
        } else {
            this.addIcon(mouseEvent.getModifiers());
        }
    }

    private void changeKeystroke() {
        int selectedIndex = this.iconLabels.indexOf(this.selected);
        String keystrokeResourceName = this.icons.get(selectedIndex).getShortcutKey();
        String keyStrokeDescription = ResourceController.getResourceController().getProperty(keystrokeResourceName);
        GrabKeyDialog keyDialog = new GrabKeyDialog(keyStrokeDescription, 14);
        keyDialog.setVisible(true);
        if (keyDialog.isOK()) {
            ResourceController.getResourceController().setProperty(keystrokeResourceName, keyDialog.getShortcut());
            this.select(selectedIndex);
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.select(((JLabel)arg0.getSource()).getLocation());
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private void select(Point location) {
        int index = this.findIndex(location);
        this.select(index);
    }

    private void select(int index) {
        String message;
        this.unhighlightSelected();
        if (index >= 0) {
            JLabel newSelected;
            this.selected = newSelected = this.iconLabels.get(index);
            this.highlightSelected();
            IconDescription iconInformation = this.icons.get(index);
            KeyStroke accelerator = this.getKeyStroke(iconInformation.getShortcutKey());
            if (accelerator != null) {
                String accText = "";
                if (accelerator != null) {
                    int keyCode;
                    int modifiers = accelerator.getModifiers() | (Compat.isMacOsX() ? 256 : 128);
                    if (modifiers > 0) {
                        accText = InputEvent.getModifiersExText(modifiers);
                        accText = accText + "+";
                    }
                    accText = (keyCode = accelerator.getKeyCode()) != 0 ? accText + KeyEvent.getKeyText(keyCode) : accText + accelerator.getKeyChar();
                }
                message = iconInformation.getTranslatedDescription() + ", " + accText;
            } else {
                message = iconInformation.getTranslatedDescription();
            }
        } else {
            this.selected = null;
            message = "";
        }
        this.descriptionLabel.setText(message);
    }

    private void unhighlightSelected() {
        if (this.selected != null) {
            this.selected.setBorder(USUAL);
        }
    }

    public void setActionListener(ActionListener listener) {
        this.listener = listener;
        this.closeAfterSelection = TranslatedElementFactory.createPropertyCheckbox("icon_selection_close_after_selection", "close_after_selection");
        this.statusPanel.add(this.closeAfterSelection);
    }

    public void addActionPanel(FastAccessableIcons.ActionPanel actionPanel) {
        actionPanel.setDisablesFocus(false);
        actionPanel.setButtonConfigurer(this::configureButton);
        Container contentPane = this.getContentPane();
        JPanel newContentPane = new JPanel(new BorderLayout());
        this.setContentPane(newContentPane);
        newContentPane.add((Component)contentPane, "Center");
        newContentPane.add((Component)actionPanel, "North");
    }

    private void configureButton(AbstractButton b) {
        b.addMouseListener(this.focusRequester);
        b.addActionListener(this.actionPanelActionListener);
    }
}

