/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util.collection;

import java.util.NoSuchElementException;
import java.util.Vector;

public class SortedMapVector {
    private static final int CAPACITY_INCREMENT = 10;
    private static final int ELEMENT_NOT_FOUND_FLAG = Integer.MIN_VALUE;
    private final Vector<MapElement> elements = new Vector(0, 10);

    public int add(Comparable key, Object value) {
        int index = this.findElement(key);
        if ((index & Integer.MIN_VALUE) != 0) {
            this.elements.add(index &= Integer.MAX_VALUE, new MapElement(key, value));
        }
        return index;
    }

    public int capacity() {
        return this.elements.capacity();
    }

    public void clear() {
        this.elements.clear();
    }

    public boolean containsKey(Comparable key) {
        int index = this.findElement(key);
        return (index & Integer.MIN_VALUE) == 0;
    }

    private int findElement(Comparable key) {
        return this.findElement(key, 0, this.size());
    }

    private int findElement(Comparable key, int first, int size) {
        if (size == 0) {
            return first | Integer.MIN_VALUE;
        }
        int halfSize = size / 2;
        int middle = first + halfSize;
        MapElement middleElement = this.elements.get(middle);
        int comparationResult = key.compareTo(middleElement.getKey());
        int last = first + size - 1;
        if (comparationResult < 0) {
            if (halfSize <= 1) {
                if (middle != first) {
                    comparationResult = key.compareTo(this.elements.get(first).getKey());
                }
                if (comparationResult < 0) {
                    return first | Integer.MIN_VALUE;
                }
                if (comparationResult == 0) {
                    return first;
                }
                return middle | Integer.MIN_VALUE;
            }
            return this.findElement(key, first, halfSize);
        }
        if (comparationResult == 0) {
            return middle;
        }
        if (halfSize <= 1) {
            if (middle != last) {
                comparationResult = key.compareTo(this.elements.get(last).getKey());
            }
            if (comparationResult < 0) {
                return last | Integer.MIN_VALUE;
            }
            if (comparationResult == 0) {
                return last;
            }
            return last + 1 | Integer.MIN_VALUE;
        }
        return this.findElement(key, middle, size - halfSize);
    }

    public Comparable getKey(int index) {
        return this.elements.get(index).getKey();
    }

    public Object getValue(Comparable key) {
        int index = this.findElement(key);
        if ((index & Integer.MIN_VALUE) == 0) {
            return this.elements.get(index).getValue();
        }
        throw new NoSuchElementException();
    }

    public Object getValue(int index) {
        return this.elements.get(index).getValue();
    }

    public int indexOf(Comparable key) {
        int index = this.findElement(key);
        if ((index & Integer.MIN_VALUE) == 0) {
            return index;
        }
        return -1;
    }

    public boolean remove(Comparable key) {
        int index = this.findElement(key);
        if ((index & Integer.MIN_VALUE) == 0) {
            this.elements.remove(index);
            return true;
        }
        return false;
    }

    public void remove(int index) {
        this.elements.removeElementAt(index);
    }

    public int size() {
        return this.elements.size();
    }

    private static class MapElement {
        private final Comparable key;
        private final Object value;

        public MapElement(Comparable key, Object value) {
            this.key = key;
            this.value = value;
        }

        Comparable getKey() {
            return this.key;
        }

        Object getValue() {
            return this.value;
        }
    }
}

