/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.map.MapView;

public class FreeSelectNodeAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final Direction direction;

    public FreeSelectNodeAction(Direction direction) {
        super("FreeSelectNodeAction." + direction.name());
        this.direction = direction;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MapView mapView = (MapView)Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        this.direction.select(mapView);
    }

    public static enum Direction {
        LEFT{

            @Override
            void select(MapView mapView) {
                mapView.selectLeft(false);
            }
        }
        ,
        CONTINIOUS_LEFT{

            @Override
            void select(MapView mapView) {
                mapView.selectLeft(true);
            }
        }
        ,
        UP{

            @Override
            void select(MapView mapView) {
                mapView.selectUp(false);
            }
        }
        ,
        CONTINIOUS_UP{

            @Override
            void select(MapView mapView) {
                mapView.selectUp(true);
            }
        }
        ,
        RIGHT{

            @Override
            void select(MapView mapView) {
                mapView.selectRight(false);
            }
        }
        ,
        CONTINIOUS_RIGHT{

            @Override
            void select(MapView mapView) {
                mapView.selectRight(true);
            }
        }
        ,
        DOWN{

            @Override
            void select(MapView mapView) {
                mapView.selectDown(false);
            }
        }
        ,
        CONTINIOUS_DOWN{

            @Override
            void select(MapView mapView) {
                mapView.selectDown(true);
            }
        };


        abstract void select(MapView var1);
    }
}

