/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.text.Normalizer;
import java.util.regex.Pattern;
import org.freeplane.features.filter.condition.CJKNormalizer;

public class StringTransformer {
    private String value;
    private static final Pattern ACCENTS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");

    public StringTransformer(String value) {
        this.value = value;
    }

    public static String transform(String value, boolean toLowerCase, boolean removeAccents) {
        if (!toLowerCase && !removeAccents) {
            return value;
        }
        StringTransformer t = new StringTransformer(value);
        if (toLowerCase) {
            t.toLowerCase();
        }
        if (removeAccents) {
            t.removeAccents().removeSpacesBetweenCJKCharacters();
        }
        return t.value();
    }

    public StringTransformer toLowerCase() {
        this.value = this.value.toLowerCase();
        return this;
    }

    public StringTransformer removeAccents() {
        this.value = ACCENTS.matcher(Normalizer.normalize(this.value, Normalizer.Form.NFD)).replaceAll("");
        return this;
    }

    public StringTransformer removeSpacesBetweenCJKCharacters() {
        this.value = CJKNormalizer.removeSpacesBetweenCJKCharacters(this.value);
        return this;
    }

    public String value() {
        return this.value;
    }
}

