/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.help;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.url.NodeAndMapReference;

class OnlineDocumentationAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final NodeAndMapReference nodeAndMapReference;

    OnlineDocumentationAction(String actionName, String urlProperty) {
        super(actionName);
        String urlString = ResourceController.getResourceController().getProperty(urlProperty);
        this.nodeAndMapReference = new NodeAndMapReference(urlString);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            final URL url = new URL(this.nodeAndMapReference.getMapReference());
            if (url == null) {
                return;
            }
            UITools.executeWhenNodeHasFocus(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (OnlineDocumentationAction.this.nodeAndMapReference.hasFreeplaneFileExtension()) {
                            Controller.getCurrentController().selectMode("MindMap");
                            MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
                            mapController.openDocumentationMap(url);
                            if (OnlineDocumentationAction.this.nodeAndMapReference.hasNodeReference()) {
                                mapController.select(OnlineDocumentationAction.this.nodeAndMapReference.getNodeReference());
                            }
                        } else {
                            Controller.getCurrentController().getViewController().openDocument(url);
                        }
                    }
                    catch (Exception e1) {
                        LogUtils.severe(e1);
                    }
                }
            });
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }
}

