/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.freeplane.features.map.Clones;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SingleNodeList;

public class DetachedNodeList
implements Clones {
    private final NodeModel clonedNode;
    private final NodeModel clone;
    private final NodeModel.CloneType cloneType;

    public DetachedNodeList(NodeModel clonedNode, NodeModel.CloneType cloneType) {
        this(clonedNode, clonedNode, cloneType);
    }

    public DetachedNodeList forClone(NodeModel node) {
        return new DetachedNodeList(node, this.clone == this.clonedNode ? node : this.clonedNode, this.cloneType);
    }

    public DetachedNodeList(NodeModel clone, NodeModel clonedNode, NodeModel.CloneType cloneType) {
        this.clone = clone;
        this.clonedNode = clonedNode;
        this.cloneType = cloneType;
    }

    @Override
    public Iterator<NodeModel> iterator() {
        return Collections.emptyList().iterator();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public void attach() {
        if (this.clonedNode == this.clone) {
            this.clone.setClones(new SingleNodeList(this.clone, this.cloneType));
        } else if (!this.clonedNode.isAttached()) {
            this.clone.setClones(new SingleNodeList(this.clone, this.cloneType));
            this.clonedNode.setClones(new DetachedNodeList(this.clonedNode, this.clone, this.cloneType));
        } else {
            Clones clonesWithNewClone = this.clonedNode.clones(this.cloneType).add(this.clone);
            this.clonedNode.setClones(clonesWithNewClone);
            this.clone.setClones(clonesWithNewClone);
        }
    }

    @Override
    public void detach(NodeModel nodeModel) {
        throw new IllegalStateException();
    }

    @Override
    public Clones add(NodeModel clone) {
        throw new IllegalStateException();
    }

    @Override
    public Collection<NodeModel> toCollection() {
        return Collections.emptyList();
    }

    @Override
    public boolean contains(NodeModel node) {
        return false;
    }

    public NodeModel otherThan(NodeModel node) {
        throw new IllegalStateException();
    }

    @Override
    public NodeModel head() {
        throw new IllegalStateException();
    }

    @Override
    public NodeModel.CloneType getCloneType() {
        return this.cloneType;
    }
}

