/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class ToggleChildrenFoldedAction
extends AFreeplaneAction {
    static final String NAME = "toggleChildrenFolded";
    private static final long serialVersionUID = 1L;

    public ToggleChildrenFoldedAction() {
        super("ToggleChildrenFoldedAction");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Controller controller = Controller.getCurrentController();
        IMapSelection mapSelection = controller.getSelection();
        Filter filter = mapSelection.getFilter();
        List<NodeModel> selectedNodes = mapSelection.getSortedSelection(true);
        MapController mapController = Controller.getCurrentModeController().getMapController();
        long unfoldedNodeCount = selectedNodes.stream().filter(node -> node.isFolded()).peek(node -> {
            node.getChildren().forEach(child -> mapController.setFolded((NodeModel)child, true, filter));
            if (selectedNodes.size() == 1) {
                mapController.unfoldAndScroll((NodeModel)node, filter);
            } else {
                mapController.unfold((NodeModel)node, filter);
            }
        }).count();
        if (unfoldedNodeCount == 0L) {
            List<NodeModel> childNodes = selectedNodes.stream().map(NodeModel::getChildren).flatMap(Collection::stream).collect(Collectors.toList());
            if (selectedNodes.size() == 1) {
                mapController.toggleFoldedAndScroll(mapSelection.getSelected(), childNodes, filter);
            } else {
                mapController.toggleFolded(filter, childNodes);
            }
        }
    }
}

