/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.addons;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.freeplane.core.io.xml.XMLLocalParserFactory;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.main.addons.AddOnInstaller;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;

public class AddOnsController {
    private static final String PATH_SEPARATOR = File.pathSeparator;
    private static final String FILES_TO_DELETE_ON_NEXT_START_PROPERTY = "addons.filesToDeleteOnNextStart";
    private static final String ADDONS_DIR = "addons";
    private static AddOnsController addOnsController;
    private List<AddOnProperties> installedAddOns = new ArrayList<AddOnProperties>();
    private boolean autoInstall;
    public static final String LATEST_VERSION_FILE = "version.properties";

    private AddOnsController() {
        this.deleteOldEmptyFiles();
        this.createAddOnsDirIfNecessary();
        this.registerPlugins();
        this.autoInstall = true;
    }

    private void deleteOldEmptyFiles() {
        ResourceController resourceController = ResourceController.getResourceController();
        String propertyValue = resourceController.getProperty(FILES_TO_DELETE_ON_NEXT_START_PROPERTY, "");
        String[] filesToDelete = propertyValue.split(PATH_SEPARATOR);
        if (!propertyValue.isEmpty()) {
            resourceController.setProperty(FILES_TO_DELETE_ON_NEXT_START_PROPERTY, "");
            resourceController.saveProperties();
        }
        for (String path : filesToDelete) {
            File file;
            if (path.isEmpty() || !(file = new File(path)).exists() || file.length() != 0L) continue;
            this.deleteFile(file);
        }
    }

    private void createAddOnsDirIfNecessary() {
        File addOnsDir = this.getAddOnsDir();
        if (addOnsDir != null && !addOnsDir.exists()) {
            LogUtils.info("creating user add-ons directory " + addOnsDir);
            addOnsDir.mkdirs();
        }
    }

    private void registerPlugins() {
        File addOnsDir = this.getAddOnsDir();
        if (addOnsDir == null) {
            return;
        }
        File[] addonXmlFiles = addOnsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".plugin.xml");
            }
        });
        if (addonXmlFiles == null) {
            LogUtils.severe("Can not read addon directory " + addOnsDir);
            return;
        }
        IXMLParser parser = XMLLocalParserFactory.createLocalXMLParser();
        for (File file : addonXmlFiles) {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
                StdXMLReader reader = new StdXMLReader(inputStream);
                parser.setReader(reader);
                this.registerInstalledAddOn(new AddOnProperties(AddOnProperties.AddOnType.PLUGIN, (XMLElement)parser.parse()));
            }
            catch (Exception e) {
                LogUtils.warn("error parsing " + file, e);
            }
        }
    }

    public static AddOnsController getController() {
        if (addOnsController == null) {
            addOnsController = new AddOnsController();
        }
        return addOnsController;
    }

    public List<AddOnProperties> getInstalledAddOns() {
        return Collections.unmodifiableList(new ArrayList<AddOnProperties>(this.installedAddOns));
    }

    public void registerInstalledAddOn(AddOnProperties addOn) {
        ModeController modeController;
        this.installedAddOns.add(addOn);
        ResourceController resourceController = ResourceController.getResourceController();
        if (addOn.getDefaultProperties() != null) {
            resourceController.addDefaults(addOn.getDefaultProperties());
        }
        if (addOn.getTranslations() != null) {
            AddOnsController.registerAddOnResources(addOn, resourceController);
        }
        if (addOn.getPreferencesXml() != null && (modeController = Controller.getCurrentModeController()) instanceof MModeController) {
            ((MModeController)modeController).getOptionPanelBuilder().load(new StringReader(addOn.getPreferencesXml()));
        }
    }

    public static void registerAddOnResources(AddOnProperties addOn, ResourceController rc) {
        LinkedHashMap<String, Map<String, String>> translations = new LinkedHashMap<String, Map<String, String>>();
        String defaultLanguage = rc.getDefaultLanguageCode();
        translations.put(defaultLanguage, AddOnsController.getLanguageResources(addOn, defaultLanguage));
        if (!defaultLanguage.equals(rc.getLanguageCode())) {
            translations.put(rc.getLanguageCode(), AddOnsController.getLanguageResources(addOn, rc.getLanguageCode()));
            AddOnsController.completeResourcesFromDefault((Map)translations.get(defaultLanguage), (Map)translations.get(rc.getLanguageCode()));
        }
        for (Map.Entry entry : translations.entrySet()) {
            rc.addLanguageResources((String)entry.getKey(), (Map)entry.getValue());
            rc.addLanguageResources((String)entry.getKey(), AddOnsController.addOptionPanelPrefix((Map)entry.getValue(), addOn.getName()));
        }
    }

    private static void completeResourcesFromDefault(Map<String, String> defaultResources, Map<String, String> selectedLanguageResources) {
        for (Map.Entry<String, String> entry : defaultResources.entrySet()) {
            if (selectedLanguageResources.get(entry.getKey()) != null) continue;
            selectedLanguageResources.put(entry.getKey(), entry.getValue());
        }
    }

    private static Map<String, String> getLanguageResources(AddOnProperties addOn, String language) {
        Map<String, String> resources = addOn.getTranslations().get(language);
        if (resources != null) {
            return AddOnsController.unescapeStrings(new LinkedHashMap<String, String>(resources));
        }
        return new LinkedHashMap<String, String>();
    }

    private static Map<String, String> unescapeStrings(Map<String, String> resources) {
        for (Map.Entry<String, String> entry : resources.entrySet()) {
            if (entry.getValue().indexOf(92) == -1) continue;
            entry.setValue(StringEscapeUtils.unescapeJava((String)entry.getValue()));
        }
        return resources;
    }

    private static Map<String, String> addOptionPanelPrefix(Map<String, String> resources, String addOnName) {
        HashMap<String, String> result = new HashMap<String, String>(resources.size());
        for (Map.Entry<String, String> entry : resources.entrySet()) {
            result.put("OptionPanel." + entry.getKey(), entry.getValue());
        }
        String nameKey = "addons." + addOnName;
        result.put("OptionPanel.separator." + nameKey, resources.get(nameKey));
        return result;
    }

    public File getAddOnsDir() {
        String userDir = ResourceController.getResourceController().getFreeplaneUserDirectory();
        return userDir == null ? null : new File(userDir, ADDONS_DIR);
    }

    public void save(AddOnProperties addOn) throws IOException {
        File addOnsDir = this.getAddOnsDir();
        if (addOnsDir != null) {
            File file = addOn.getAddOnPropertiesFile();
            if (file == null) {
                file = new File(addOnsDir, addOn.getName() + "." + addOn.getAddOnType().name().toLowerCase() + ".xml");
            }
            FileUtils.dumpStringToFile(addOn.toXmlString(), file, "UTF-8");
        }
    }

    public void deinstall(AddOnProperties addOn) {
        String previousFilesToDeleteOnNextStart = ResourceController.getResourceController().getProperty(FILES_TO_DELETE_ON_NEXT_START_PROPERTY, "");
        StringBuilder filesToDeleteOnNextStart = new StringBuilder(previousFilesToDeleteOnNextStart);
        LogUtils.info("deinstalling " + addOn);
        for (String[] rule : addOn.getDeinstallationRules()) {
            String path;
            boolean deleted;
            if (!rule[0].equals("delete") || (deleted = this.deleteFile(path = this.expandVariables(rule)))) continue;
            filesToDeleteOnNextStart.append(PATH_SEPARATOR);
            filesToDeleteOnNextStart.append(path);
        }
        this.installedAddOns.remove(addOn);
        if (filesToDeleteOnNextStart.length() > previousFilesToDeleteOnNextStart.length()) {
            ResourceController.getResourceController().setProperty(FILES_TO_DELETE_ON_NEXT_START_PROPERTY, filesToDeleteOnNextStart.toString());
        }
    }

    private boolean deleteFile(String path) {
        File file = new File(path);
        return this.deleteFile(file);
    }

    private boolean deleteFile(File file) {
        boolean deleted;
        if (!file.exists()) {
            LogUtils.warn("file " + file.getPath() + " should be deleted but does not exist");
        } else if (file.delete()) {
            LogUtils.info("deleted " + file.getPath());
        } else {
            LogUtils.warn("could not delete file " + file.getPath());
        }
        boolean bl = deleted = !file.exists();
        if (!deleted) {
            try {
                FileWriter truncating = new FileWriter(file, false);
                ((Writer)truncating).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return deleted;
    }

    private String expandVariables(String[] rule) {
        return rule[1].replace("${installationbase}", ResourceController.getResourceController().getFreeplaneUserDirectory());
    }

    public boolean installIfAppropriate(URL url) {
        if (!this.autoInstall) {
            return false;
        }
        if (url.getFile().endsWith(".addon.mm")) {
            AddOnInstaller installer = Controller.getCurrentModeController().getExtension(AddOnInstaller.class);
            if (installer == null) {
                LogUtils.warn("no AddOnInstaller registered. Cannot install " + url);
                return false;
            }
            UITools.backOtherWindows();
            int selection = UITools.showConfirmDialog(null, TextUtils.format("newmap.install.addon.question", new File(url.getFile()).getName()), TextUtils.getText("newmap.install.addon.title"), 0, -1);
            if (selection == 0) {
                installer.install(url);
                return true;
            }
        }
        return false;
    }

    public void setAutoInstallEnabled(boolean autoInstall) {
        this.autoInstall = autoInstall;
    }

    public boolean isAutoInstallEnabled() {
        return this.autoInstall;
    }

    public AddOnProperties getInstalledAddOn(String name) {
        for (AddOnProperties addOn : this.installedAddOns) {
            if (!addOn.getName().equals(name)) continue;
            return addOn;
        }
        return null;
    }
}

