/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.freeplane.view.swing.map.CombineOperation;
import org.freeplane.view.swing.map.CombinedFunction;
import org.freeplane.view.swing.map.SegmentFunction;
import org.freeplane.view.swing.map.TranslatedFunction;

public interface StepFunction {
    public static final int DEFAULT_VALUE = Integer.MAX_VALUE;

    public int evaluate(int var1);

    public Set<Integer> samplePoints();

    default public int distance(StepFunction other) {
        if (other == null) {
            return 0;
        }
        HashSet<Integer> pts = new HashSet<Integer>(this.samplePoints());
        pts.addAll(other.samplePoints());
        int minX = Math.max(this.minX(), other.minX());
        int maxX = Math.min(this.maxX(), other.maxX());
        int min = Integer.MAX_VALUE;
        Iterator iterator = pts.iterator();
        while (iterator.hasNext()) {
            int x = (Integer)iterator.next();
            if (minX > x || x > maxX) continue;
            int y1 = this.evaluate(x);
            int y2 = other.evaluate(x);
            if (y1 == Integer.MAX_VALUE || y2 == Integer.MAX_VALUE) continue;
            int d = y1 - y2;
            min = min == Integer.MAX_VALUE ? d : Math.min(min, d);
        }
        return min;
    }

    public static StepFunction segment(int x1, int x2, int y) {
        return new SegmentFunction(x1, x2, y);
    }

    default public StepFunction translate(int dx, int dy) {
        return new TranslatedFunction(this, dx, dy);
    }

    default public StepFunction combine(StepFunction other, CombineOperation op) {
        return other == null ? this : new CombinedFunction(this, other, op);
    }

    default public String explain() {
        return new TreeSet<Integer>(this.samplePoints()).stream().map(this::explain).collect(Collectors.joining(", "));
    }

    default public String explain(int x) {
        int y = this.evaluate(x);
        int yBefore = this.evaluate(x - 1);
        int yAfter = this.evaluate(x + 1);
        StringBuilder builder = new StringBuilder();
        if (yBefore != Integer.MAX_VALUE && yBefore != y) {
            builder.append(this.explain(x - 1, yBefore) + ", ");
        }
        builder.append(this.explain(x, y));
        if (yAfter != Integer.MAX_VALUE && yAfter != y) {
            builder.append(", " + this.explain(x + 1, yAfter));
        }
        return builder.toString();
    }

    default public String explain(int x, int y) {
        return "" + y + "(" + x + ")";
    }

    public int minX();

    public int maxX();
}

