/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.util.Set;
import java.util.stream.Collectors;
import org.freeplane.view.swing.map.StepFunction;

class TranslatedFunction
implements StepFunction {
    private final StepFunction inner;
    private final int dx;
    private final int dy;

    public TranslatedFunction(StepFunction inner, int dx, int dy) {
        if (inner == null) {
            throw new IllegalArgumentException();
        }
        this.inner = inner;
        this.dx = dx;
        this.dy = dy;
    }

    @Override
    public int evaluate(int x) {
        int val = this.inner.evaluate(x - this.dx);
        return val == Integer.MAX_VALUE ? Integer.MAX_VALUE : val + this.dy;
    }

    @Override
    public Set<Integer> samplePoints() {
        return this.inner.samplePoints().stream().map(p -> p + this.dx).collect(Collectors.toSet());
    }

    @Override
    public int minX() {
        return this.inner.minX() + this.dx;
    }

    @Override
    public int maxX() {
        return this.inner.maxX() + this.dx;
    }

    @Override
    public StepFunction translate(int dx, int dy) {
        return this.inner.translate(this.dx + dx, this.dy + dy);
    }

    public String toString() {
        return this.explain();
    }
}

