/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.link;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;

class PathBBox {
    PathBBox() {
    }

    private static void accum(double[] bounds, double x, double y) {
        bounds[0] = Math.min(bounds[0], x);
        bounds[1] = Math.min(bounds[1], y);
        bounds[2] = Math.max(bounds[2], x);
        bounds[3] = Math.max(bounds[3], y);
    }

    private static void accumCubic(double[] bounds, double t, double curx, double cury, double cpx0, double cpy0, double cpx1, double cpy1, double endx, double endy) {
        double u = 1.0 - t;
        double x = curx * u * u * u + 3.0 * cpx0 * t * u * u + 3.0 * cpx1 * t * t * u + endx * t * t * t;
        double y = cury * u * u * u + 3.0 * cpy0 * t * u * u + 3.0 * cpy1 * t * t * u + endy * t * t * t;
        PathBBox.accum(bounds, x, y);
    }

    private static void accumQuad(double[] bounds, double t, double curx, double cury, double cpx0, double cpy0, double endx, double endy) {
        double u = 1.0 - t;
        double x = curx * u * u + 2.0 * cpx0 * t * u + endx * t * t;
        double y = cury * u * u + 2.0 * cpy0 * t * u + endy * t * t;
        PathBBox.accum(bounds, x, y);
    }

    private static int findCubicZeros(double[] zeros, double cur, double cp0, double cp1, double end) {
        zeros[0] = (cp0 - cur) * 3.0;
        zeros[1] = (cp1 - cp0 - cp0 + cur) * 6.0;
        zeros[2] = (end + (cp0 - cp1) * 3.0 - cur) * 3.0;
        int num = QuadCurve2D.solveQuadratic(zeros);
        int ret = 0;
        for (int i = 0; i < num; ++i) {
            double t = zeros[i];
            if (!(t > 0.0) || !(t < 1.0)) continue;
            zeros[ret] = t;
            ++ret;
        }
        return ret;
    }

    private static double findQuadZero(double cur, double cp, double end) {
        return -(cp + cp - cur - cur) / (2.0 * (cur - cp - cp + end));
    }

    public static Rectangle2D getBBox(Shape s) {
        boolean first = true;
        double[] bounds = new double[4];
        double[] coords = new double[6];
        double curx = 0.0;
        double cury = 0.0;
        double movx = 0.0;
        double movy = 0.0;
        PathIterator pi = s.getPathIterator(null);
        while (!pi.isDone()) {
            pi.currentSegment(coords);
            switch (pi.currentSegment(coords)) {
                case 0: {
                    movx = curx = coords[0];
                    movy = cury = coords[1];
                    if (first) {
                        bounds[0] = bounds[2] = curx;
                        bounds[1] = bounds[3] = cury;
                        first = false;
                        break;
                    }
                    PathBBox.accum(bounds, curx, cury);
                    break;
                }
                case 1: {
                    curx = coords[0];
                    cury = coords[1];
                    PathBBox.accum(bounds, curx, cury);
                    break;
                }
                case 2: {
                    double cpx0 = coords[0];
                    double cpy0 = coords[1];
                    double endx = coords[2];
                    double endy = coords[3];
                    double t = PathBBox.findQuadZero(curx, cpx0, endx);
                    if (t > 0.0 && t < 1.0) {
                        PathBBox.accumQuad(bounds, t, curx, cury, cpx0, cpy0, endx, endy);
                    }
                    if ((t = PathBBox.findQuadZero(cury, cpy0, endy)) > 0.0 && t < 1.0) {
                        PathBBox.accumQuad(bounds, t, curx, cury, cpx0, cpy0, endx, endy);
                    }
                    curx = endx;
                    cury = endy;
                    PathBBox.accum(bounds, curx, cury);
                    break;
                }
                case 3: {
                    int i;
                    double cpx0 = coords[0];
                    double cpy0 = coords[1];
                    double cpx1 = coords[2];
                    double cpy1 = coords[3];
                    double endx = coords[4];
                    double endy = coords[5];
                    int num = PathBBox.findCubicZeros(coords, curx, cpx0, cpx1, endx);
                    for (i = 0; i < num; ++i) {
                        PathBBox.accumCubic(bounds, coords[i], curx, cury, cpx0, cpy0, cpx1, cpy1, endx, endy);
                    }
                    num = PathBBox.findCubicZeros(coords, cury, cpy0, cpy1, endy);
                    for (i = 0; i < num; ++i) {
                        PathBBox.accumCubic(bounds, coords[i], curx, cury, cpx0, cpy0, cpx1, cpy1, endx, endy);
                    }
                    curx = endx;
                    cury = endy;
                    PathBBox.accum(bounds, curx, cury);
                    break;
                }
                case 4: {
                    curx = movx;
                    cury = movy;
                }
            }
            pi.next();
        }
        return new Rectangle2D.Double(bounds[0], bounds[1], bounds[2] - bounds[0], bounds[3] - bounds[1]);
    }
}

