/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.protocol.data;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

final class Messages {
    private static final Map<Locale, ResourceBundle> BUNDLES = new ConcurrentHashMap<Locale, ResourceBundle>();
    static final DataURLConnection_ dataURLConnection = new DataURLConnection_();
    static final Handler_ handler = new Handler_();
    static final MediaType_ mediaType = new MediaType_();

    private Messages() {
        throw new IllegalStateException("cannot create instances of " + this.getClass().getName());
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        Locale l = Messages.nonNull(locale);
        return BUNDLES.computeIfAbsent(l, k -> ResourceBundle.getBundle("com.github.robtimus.net.protocol.data.data-url", l));
    }

    private static String getString(Locale locale, String key) {
        ResourceBundle bundle = Messages.getResourceBundle(locale);
        return bundle.getString(key);
    }

    private static Locale nonNull(Locale locale) {
        return locale != null ? locale : Locale.getDefault(Locale.Category.FORMAT);
    }

    static final class MediaType_ {
        private MediaType_() {
        }

        String invalidMimeType(Object arg) {
            return this.invalidMimeType(null, arg);
        }

        String invalidMimeType(Locale locale, Object arg) {
            Locale l = Messages.nonNull(locale);
            String s = Messages.getString(l, "mediaType.invalidMimeType");
            return String.format(l, s, arg);
        }
    }

    static final class Handler_ {
        private Handler_() {
        }

        String invalidProtocol(Object arg1, Object arg2) {
            return this.invalidProtocol(null, arg1, arg2);
        }

        String invalidProtocol(Locale locale, Object arg1, Object arg2) {
            Locale l = Messages.nonNull(locale);
            String s = Messages.getString(l, "handler.invalidProtocol");
            return String.format(l, s, arg1, arg2);
        }

        String missingComma(Object arg) {
            return this.missingComma(null, arg);
        }

        String missingComma(Locale locale, Object arg) {
            Locale l = Messages.nonNull(locale);
            String s = Messages.getString(l, "handler.missingComma");
            return String.format(l, s, arg);
        }
    }

    static final class DataURLConnection_ {
        final GetInputStream_ getInputStream = new GetInputStream_();

        private DataURLConnection_() {
        }

        static final class GetInputStream_ {
            private GetInputStream_() {
            }

            String falseDoInput() {
                return this.falseDoInput(null);
            }

            String falseDoInput(Locale locale) {
                Locale l = Messages.nonNull(locale);
                return Messages.getString(l, "dataURLConnection.getInputStream.falseDoInput");
            }
        }
    }
}

