/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.syntaxpane.actions;

import de.sciss.syntaxpane.SyntaxDocument;
import de.sciss.syntaxpane.actions.DefaultSyntaxAction;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class PairAction
extends DefaultSyntaxAction
implements DocumentListener {
    private Document listeningDocument = null;
    private final List<Integer> endPositions = new LinkedList<Integer>();
    private static Map<String, String> PAIRS = new HashMap<String, String>(4);

    public PairAction() {
        super("PAIR_ACTION");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        String key = e.getActionCommand();
        if (this.listeningDocument != sDoc) {
            if (this.listeningDocument != null) {
                this.listeningDocument.removeDocumentListener(this);
            }
            this.listeningDocument = sDoc;
            sDoc.addDocumentListener(this);
        }
        String left = key;
        String right = PAIRS.get(left);
        String selected = target.getSelectedText();
        if (selected != null) {
            if (right != null) {
                target.replaceSelection(left + selected + right);
            } else {
                target.replaceSelection(key);
            }
        } else {
            boolean unhandled = true;
            try {
                Iterator<Integer> positionIter = this.endPositions.iterator();
                while (positionIter.hasNext()) {
                    String nextChar;
                    int trackedPosition = positionIter.next();
                    if (target.getCaretPosition() != trackedPosition || !(nextChar = target.getDocument().getText(target.getCaretPosition(), 1)).equals(key)) continue;
                    target.replaceSelection("");
                    target.setCaretPosition(target.getCaretPosition() + 1);
                    positionIter.remove();
                    unhandled = false;
                    break;
                }
            }
            catch (BadLocationException e1) {
                throw new RuntimeException("Internal logic error", e1);
            }
            if (unhandled) {
                if (right != null) {
                    target.replaceSelection(left + right);
                    target.setCaretPosition(target.getCaretPosition() - right.length());
                    this.endPositions.add(target.getCaretPosition());
                } else {
                    target.replaceSelection(key);
                }
            }
        }
    }

    @Override
    public void deinstall(JEditorPane editor) {
        super.deinstall(editor);
        editor.getDocument().removeDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        ListIterator<Integer> positionIter = this.endPositions.listIterator();
        while (positionIter.hasNext()) {
            int position = positionIter.next();
            if (position >= e.getOffset()) {
                positionIter.set(position += e.getLength());
                continue;
            }
            positionIter.remove();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        ListIterator<Integer> positionIter = this.endPositions.listIterator();
        while (positionIter.hasNext()) {
            int position = positionIter.next();
            if (position >= e.getOffset()) {
                if (position >= e.getOffset() + e.getLength()) {
                    positionIter.set(position -= e.getLength());
                    continue;
                }
                positionIter.remove();
                continue;
            }
            positionIter.remove();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    static {
        PAIRS.put("(", ")");
        PAIRS.put("[", "]");
        PAIRS.put("\"", "\"");
        PAIRS.put("'", "'");
    }
}

