/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.DictionaryBase;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

final class Dictionary
extends DictionaryBase {
    public Dictionary() {
        this.tree = new char[10000];
        this.tree[this.size++] = 65535;
    }

    public Dictionary(char[] tree) {
        super(tree);
    }

    public void add(String word) {
        this.idx = 0;
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            this.searchCharOrAdd(c);
            if (i == word.length() - 1) {
                int n = this.idx + 1;
                this.tree[n] = (char)(this.tree[n] | 0x8000);
                return;
            }
            int nextIdx = this.readIndex();
            this.idx = nextIdx == 0 ? this.createNewNode() : nextIdx;
        }
    }

    private final void checkSize(int newSize) {
        if (newSize > this.tree.length) {
            char[] puffer = new char[Math.max(newSize, 2 * this.tree.length)];
            System.arraycopy(this.tree, 0, puffer, 0, this.size);
            this.tree = puffer;
        }
    }

    private final int createNewNode() {
        this.checkSize(this.size + 1);
        int n = this.idx + 1;
        this.tree[n] = (char)(this.tree[n] | (char)(this.size >> 16));
        int n2 = this.idx + 2;
        this.tree[n2] = (char)(this.tree[n2] | (char)this.size);
        this.idx = this.size++;
        this.tree[this.idx] = 65535;
        return this.idx;
    }

    public int getDataSize() {
        return this.size;
    }

    private void insertChar(char c) {
        this.checkSize(this.size + 3);
        System.arraycopy(this.tree, this.idx, this.tree, this.idx + 3, this.size - this.idx);
        this.tree[this.idx] = c;
        this.tree[this.idx + 1] = '\u0000';
        this.tree[this.idx + 2] = '\u0000';
        this.size += 3;
        int i = 0;
        while (i < this.size) {
            if (this.tree[i] == '\uffff') {
                ++i;
                continue;
            }
            int index = (this.tree[i + 1] << 16) + this.tree[i + 2];
            int indexValue = index & Integer.MAX_VALUE;
            if (indexValue > this.idx) {
                this.tree[i + 1] = (char)((index += 3) >> 16);
                this.tree[i + 2] = (char)index;
            }
            i += 3;
        }
    }

    public void load(InputStream stream) throws IOException {
        try (BufferedInputStream zip = new BufferedInputStream(new InflaterInputStream(stream));){
            this.size = 0;
            while (((InputStream)zip).available() > 0) {
                char c = (char)(((InputStream)zip).read() + (((InputStream)zip).read() << 8));
                this.checkSize(this.size + 1);
                this.tree[this.size++] = c;
            }
        }
        this.trimToSize();
    }

    public void load(String filename) throws IOException {
        FileInputStream fos = new FileInputStream(filename);
        this.load(fos);
    }

    public void save(OutputStream stream) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setLevel(9);
        try (DeflaterOutputStream zip = new DeflaterOutputStream(stream, deflater);){
            for (int i = 0; i < this.size; ++i) {
                zip.write(this.tree[i]);
                zip.write(this.tree[i] >> 8);
            }
        }
    }

    public long save(String filename) throws IOException {
        File file = new File(filename);
        FileOutputStream fos = new FileOutputStream(file);
        this.save(fos);
        return file.length();
    }

    private void searchCharOrAdd(char c) {
        if (c == '\uffff') {
            throw new RuntimeException("Invalid Character");
        }
        while (this.idx < this.size && this.tree[this.idx] < c) {
            this.idx += 3;
        }
        if (this.idx >= this.size) {
            throw new RuntimeException("Internal Error");
        }
        if (this.tree[this.idx] == c) {
            return;
        }
        this.insertChar(c);
    }

    public char[] toArray() {
        char[] puffer = new char[this.size];
        System.arraycopy(this.tree, 0, puffer, 0, this.size);
        return puffer;
    }

    void trimToSize() {
        char[] temp = new char[this.size];
        System.arraycopy(this.tree, 0, temp, 0, this.size);
        this.tree = temp;
    }
}

