/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLHelper {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static final String XERCES_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    static final String XML_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String XML_ACCESS_EXTERNAL_SCHEMA = "http://javax.xml.XMLConstants/property/accessExternalSchema";
    private static final String XML_ACCESS_EXTERNAL_DTD = "http://javax.xml.XMLConstants/property/accessExternalDTD";
    public static final String ALLOW_DOCTYPE_PROCESSING = "ivy.xml.allow-doctype-processing";
    public static final String EXTERNAL_RESOURCES = "ivy.xml.external-resources";
    private static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new StringReader(""));

    private static SAXParser newSAXParser(URL schema, InputStream schemaStream, boolean allowXmlDoctypeProcessing, ExternalResources externalResources) throws ParserConfigurationException, SAXException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        parserFactory.setValidating(schema != null);
        XMLHelper.configureSafeFeatures(parserFactory, allowXmlDoctypeProcessing, externalResources);
        SAXParser parser = parserFactory.newSAXParser();
        if (schema != null) {
            try {
                parser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                parser.setProperty(JAXP_SCHEMA_SOURCE, schemaStream);
            }
            catch (SAXNotRecognizedException ex) {
                Message.warn("problem while setting JAXP validating property on SAXParser... XML validation will not be done", ex);
                parserFactory.setValidating(false);
                parser = parserFactory.newSAXParser();
            }
        }
        XMLReader reader = parser.getXMLReader();
        XMLHelper.trySetFeature(reader, XML_NAMESPACE_PREFIXES, true);
        XMLHelper.trySetProperty(reader, XML_ACCESS_EXTERNAL_SCHEMA, externalResources.getAllowedProtocols());
        XMLHelper.trySetProperty(reader, XML_ACCESS_EXTERNAL_DTD, externalResources.getAllowedProtocols());
        return parser;
    }

    public static String toSystemId(URL url) {
        try {
            return new URI(url.toExternalForm()).toASCIIString();
        }
        catch (URISyntaxException e) {
            return url.toExternalForm();
        }
    }

    public static void parse(URL xmlURL, URL schema, DefaultHandler handler) throws SAXException, IOException, ParserConfigurationException {
        XMLHelper.parse(xmlURL, schema, handler, null);
    }

    public static void parse(URL xmlURL, URL schema, DefaultHandler handler, LexicalHandler lHandler) throws SAXException, IOException, ParserConfigurationException {
        XMLHelper.parse(xmlURL, schema, handler, lHandler, ExternalResources.fromSystemProperty());
    }

    public static void parse(URL xmlURL, URL schema, DefaultHandler handler, LexicalHandler lHandler, ExternalResources externalResources) throws SAXException, IOException, ParserConfigurationException {
        try (InputStream xmlStream = URLHandlerRegistry.getDefault().openStream(xmlURL);){
            InputSource inSrc = new InputSource(xmlStream);
            inSrc.setSystemId(XMLHelper.toSystemId(xmlURL));
            XMLHelper.parse(inSrc, schema, handler, lHandler, externalResources);
        }
    }

    public static void parse(InputStream xmlStream, URL schema, DefaultHandler handler, LexicalHandler lHandler) throws SAXException, IOException, ParserConfigurationException {
        XMLHelper.parse(xmlStream, schema, handler, lHandler, ExternalResources.fromSystemProperty());
    }

    public static void parse(InputStream xmlStream, URL schema, DefaultHandler handler, LexicalHandler lHandler, ExternalResources externalResources) throws SAXException, IOException, ParserConfigurationException {
        XMLHelper.parse(new InputSource(xmlStream), schema, handler, lHandler);
    }

    public static void parse(InputSource xmlStream, URL schema, DefaultHandler handler, LexicalHandler lHandler) throws SAXException, IOException, ParserConfigurationException {
        XMLHelper.parse(xmlStream, schema, handler, lHandler, ExternalResources.fromSystemProperty());
    }

    public static void parse(InputSource xmlStream, URL schema, DefaultHandler handler, LexicalHandler lHandler, boolean loadExternalDtds) throws SAXException, IOException, ParserConfigurationException {
        XMLHelper.parse(xmlStream, schema, handler, lHandler, loadExternalDtds ? ExternalResources.LOCAL_ONLY : ExternalResources.PROHIBIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(InputSource xmlStream, URL schema, DefaultHandler handler, LexicalHandler lHandler, ExternalResources externalResources) throws SAXException, IOException, ParserConfigurationException {
        InputStream schemaStream = null;
        try {
            if (schema != null) {
                schemaStream = URLHandlerRegistry.getDefault().openStream(schema);
            }
            SAXParser parser = XMLHelper.newSAXParser(schema, schemaStream, XMLHelper.isXmlDoctypeProcessingAllowed(), externalResources);
            if (lHandler != null) {
                try {
                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", lHandler);
                }
                catch (SAXException ex) {
                    Message.warn("problem while setting the lexical handler property on SAXParser", ex);
                }
            }
            DefaultHandler h = externalResources == ExternalResources.IGNORE ? new NoopEntityResolverDefaultHandler(handler) : handler;
            parser.parse(xmlStream, h);
        }
        finally {
            if (schemaStream != null) {
                try {
                    schemaStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean canUseSchemaValidation() {
        return true;
    }

    public static String escape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(text.length());
        block6: for (char ch : text.toCharArray()) {
            switch (ch) {
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '\'': {
                    result.append("&apos;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    public static Document parseToDom(InputSource source, EntityResolver entityResolver) throws IOException, SAXException {
        return XMLHelper.parseToDom(source, entityResolver, XMLHelper.isXmlDoctypeProcessingAllowed(), ExternalResources.fromSystemProperty());
    }

    public static Document parseToDom(InputSource source, EntityResolver entityResolver, boolean allowXmlDoctypeProcessing, ExternalResources externalResources) throws IOException, SAXException {
        DocumentBuilder docBuilder = XMLHelper.getDocBuilder(entityResolver, allowXmlDoctypeProcessing, externalResources);
        return docBuilder.parse(source);
    }

    public static DocumentBuilder getDocBuilder(EntityResolver entityResolver) {
        return XMLHelper.getDocBuilder(entityResolver, XMLHelper.isXmlDoctypeProcessingAllowed(), ExternalResources.fromSystemProperty());
    }

    public static DocumentBuilder getDocBuilder(EntityResolver entityResolver, boolean allowXmlDoctypeProcessing, ExternalResources externalResources) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            XMLHelper.configureSafeFeatures(factory, allowXmlDoctypeProcessing, externalResources);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            if (externalResources == ExternalResources.IGNORE) {
                entityResolver = new NoopEntityResolver(entityResolver);
            }
            if (entityResolver != null) {
                docBuilder.setEntityResolver(entityResolver);
            }
            return docBuilder;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Transformer getTransformer(Source source) throws TransformerConfigurationException {
        SAXTransformerFactory factory = XMLHelper.getTransformerFactory();
        return factory.newTransformer(source);
    }

    public static TransformerHandler getTransformerHandler() throws TransformerConfigurationException {
        SAXTransformerFactory factory = XMLHelper.getTransformerFactory();
        return factory.newTransformerHandler();
    }

    public static boolean isXmlDoctypeProcessingAllowed() {
        return "true".equals(System.getProperty(ALLOW_DOCTYPE_PROCESSING));
    }

    private XMLHelper() {
    }

    private static SAXTransformerFactory getTransformerFactory() {
        TransformerFactory factory = SAXTransformerFactory.newInstance();
        XMLHelper.configureSafeFeatures(factory);
        return (SAXTransformerFactory)factory;
    }

    private static void configureSafeFeatures(DocumentBuilderFactory factory, boolean allowXmlDoctypeProcessing, ExternalResources externalResources) {
        String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
        XMLHelper.trySetFeature(factory, "http://apache.org/xml/features/disallow-doctype-decl", !allowXmlDoctypeProcessing);
        String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";
        XMLHelper.trySetFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        String ALLOW_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
        XMLHelper.trySetFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
        String ALLOW_EXTERNAL_PARAM_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
        XMLHelper.trySetFeature(factory, "http://xml.org/sax/features/external-parameter-entities", false);
        String LOAD_EXTERNAL_DTD = XERCES_LOAD_EXTERNAL_DTD;
        XMLHelper.trySetFeature(factory, XERCES_LOAD_EXTERNAL_DTD, externalResources != ExternalResources.PROHIBIT);
        try {
            factory.setXIncludeAware(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            factory.setExpandEntityReferences(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void configureSafeFeatures(SAXParserFactory factory, boolean allowXmlDoctypeProcessing, ExternalResources externalResources) {
        String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
        XMLHelper.trySetFeature(factory, "http://apache.org/xml/features/disallow-doctype-decl", !allowXmlDoctypeProcessing);
        String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";
        XMLHelper.trySetFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        boolean allowEntities = externalResources == ExternalResources.LOCAL_ONLY || externalResources == ExternalResources.ALL;
        String ALLOW_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
        XMLHelper.trySetFeature(factory, "http://xml.org/sax/features/external-general-entities", allowEntities);
        String ALLOW_EXTERNAL_PARAM_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
        XMLHelper.trySetFeature(factory, "http://xml.org/sax/features/external-parameter-entities", allowEntities);
        String LOAD_EXTERNAL_DTD = XERCES_LOAD_EXTERNAL_DTD;
        XMLHelper.trySetFeature(factory, XERCES_LOAD_EXTERNAL_DTD, externalResources != ExternalResources.PROHIBIT);
        try {
            factory.setXIncludeAware(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void configureSafeFeatures(TransformerFactory factory) {
        XMLHelper.trySetAttribute(factory, XML_ACCESS_EXTERNAL_DTD, "");
        XMLHelper.trySetAttribute(factory, XML_ACCESS_EXTERNAL_SCHEMA, "");
        XMLHelper.trySetAttribute(factory, "http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
    }

    private static boolean isFeatureSupported(SAXParserFactory factory, String feature) {
        try {
            factory.getFeature(feature);
            return true;
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        catch (SAXNotRecognizedException e) {
            return false;
        }
        catch (SAXNotSupportedException e) {
            return false;
        }
    }

    private static boolean isFeatureSupported(DocumentBuilderFactory factory, String feature) {
        try {
            factory.getFeature(feature);
            return true;
        }
        catch (ParserConfigurationException e) {
            return false;
        }
    }

    private static boolean isFeatureSupported(XMLReader reader, String feature) {
        try {
            reader.getFeature(feature);
            return true;
        }
        catch (SAXException e) {
            return false;
        }
    }

    private static boolean isAttributeSupported(TransformerFactory factory, String attribute) {
        try {
            factory.getAttribute(attribute);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean isPropertySupported(XMLReader reader, String property) {
        try {
            reader.getProperty(property);
            return true;
        }
        catch (SAXException e) {
            return false;
        }
    }

    private static boolean trySetFeature(DocumentBuilderFactory factory, String feature, boolean val) {
        if (!XMLHelper.isFeatureSupported(factory, feature)) {
            return false;
        }
        try {
            factory.setFeature(feature, val);
            return true;
        }
        catch (ParserConfigurationException e) {
            Message.warn("Failed to set feature " + feature + " on DocumentBuilderFactory", e);
            return false;
        }
    }

    private static boolean trySetFeature(SAXParserFactory factory, String feature, boolean val) {
        if (!XMLHelper.isFeatureSupported(factory, feature)) {
            return false;
        }
        try {
            factory.setFeature(feature, val);
            return true;
        }
        catch (ParserConfigurationException e) {
            Message.warn("Failed to set feature " + feature + " on SAXParserFactory", e);
            return false;
        }
        catch (SAXNotRecognizedException e) {
            Message.warn("Failed to set feature " + feature + " on SAXParserFactory", e);
            return false;
        }
        catch (SAXNotSupportedException e) {
            Message.warn("Failed to set feature " + feature + " on SAXParserFactory", e);
            return false;
        }
    }

    private static boolean trySetFeature(XMLReader reader, String feature, boolean val) {
        if (!XMLHelper.isFeatureSupported(reader, feature)) {
            return false;
        }
        try {
            reader.setFeature(feature, val);
            return true;
        }
        catch (SAXException e) {
            Message.warn("Failed to set feature " + feature + " on XMLReader", e);
            return false;
        }
    }

    private static boolean trySetAttribute(TransformerFactory factory, String attribute, String val) {
        if (!XMLHelper.isAttributeSupported(factory, attribute)) {
            return false;
        }
        try {
            factory.setAttribute(attribute, val);
            return true;
        }
        catch (IllegalArgumentException e) {
            Message.warn("Failed to set attribute " + attribute + " on TransformerFactory", e);
            return false;
        }
    }

    private static boolean trySetProperty(XMLReader reader, String property, Object val) {
        if (!XMLHelper.isPropertySupported(reader, property)) {
            return false;
        }
        try {
            reader.setProperty(property, val);
            return true;
        }
        catch (SAXException e) {
            Message.warn("Failed to set property " + property + " on XMLReader", e);
            return false;
        }
    }

    private static class NoopEntityResolverDefaultHandler
    extends DefaultHandler {
        private DefaultHandler wrapped;

        private NoopEntityResolverDefaultHandler(DefaultHandler wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource s;
            if (this.wrapped != null && (s = this.wrapped.resolveEntity(publicId, systemId)) != null) {
                return s;
            }
            return EMPTY_INPUT_SOURCE;
        }

        @Override
        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            this.wrapped.notationDecl(name, publicId, systemId);
        }

        @Override
        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            this.wrapped.unparsedEntityDecl(name, publicId, systemId, notationName);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.wrapped.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.wrapped.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.wrapped.endDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.wrapped.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.wrapped.endPrefixMapping(prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.wrapped.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.wrapped.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.wrapped.characters(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.wrapped.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.wrapped.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.wrapped.skippedEntity(name);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.wrapped.warning(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.wrapped.error(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.wrapped.fatalError(e);
        }
    }

    private static class NoopEntityResolver
    implements EntityResolver {
        private EntityResolver wrapped;

        private NoopEntityResolver(EntityResolver wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource s;
            if (this.wrapped != null && (s = this.wrapped.resolveEntity(publicId, systemId)) != null) {
                return s;
            }
            return EMPTY_INPUT_SOURCE;
        }
    }

    public static enum ExternalResources {
        PROHIBIT(""),
        IGNORE("all"),
        LOCAL_ONLY("file, jar:file"),
        ALL("all");

        private final String allowedProtocols;

        private ExternalResources(String allowedProtocols) {
            this.allowedProtocols = allowedProtocols;
        }

        private String getAllowedProtocols() {
            return this.allowedProtocols;
        }

        public static ExternalResources fromSystemProperty() {
            String val = System.getProperty(XMLHelper.EXTERNAL_RESOURCES);
            if (val != null) {
                if (val.equalsIgnoreCase("ignore")) {
                    return IGNORE;
                }
                if (val.equalsIgnoreCase("all")) {
                    return ALL;
                }
                if (val.equalsIgnoreCase("local-only") || val.equalsIgnoreCase("local_only")) {
                    return LOCAL_ONLY;
                }
            }
            return PROHIBIT;
        }
    }
}

