/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValueList;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.LinkedList;
import org.w3c.dom.DOMException;

public class LinkedCSSValueList
extends LinkedList<StyleValue>
implements CSSValueList<StyleValue> {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean add(StyleValue value) {
        return super.add(value);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public StyleValue item(int index) {
        return (StyleValue)this.get(index);
    }

    @Override
    public LinkedCSSValueList clone() {
        LinkedCSSValueList copy = new LinkedCSSValueList();
        copy.addAll(this);
        return copy;
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public String getCssText() {
        if (this.isEmpty()) {
            return "";
        }
        BufferSimpleWriter sw = new BufferSimpleWriter(this.size() * 24 + 16);
        try {
            this.writeCssText((SimpleWriter)sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(this.size() * 24 + 16);
        buf.append(this.item(0).getMinifiedCssText(propertyName));
        int sz = this.size();
        for (int i = 1; i < sz; ++i) {
            buf.append(',').append(this.item(i).getMinifiedCssText(propertyName));
        }
        return buf.toString();
    }

    @Override
    public StyleValue set(int index, StyleValue value) {
        if (value == null) {
            throw new NullPointerException("Null value set to ValueList");
        }
        return super.set(index, value);
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        if (!this.isEmpty()) {
            ((StyleValue)this.get(0)).writeCssText(wri);
            int sz = this.size();
            for (int i = 1; i < sz; ++i) {
                wri.write(',');
                wri.write(' ');
                ((StyleValue)this.get(i)).writeCssText(wri);
            }
        }
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "This value has to be modified by accessing its elements.");
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax syntax) {
        CSSValueSyntax.Match result = CSSValueSyntax.Match.FALSE;
        if (!this.isEmpty() && syntax != null) {
            if (this.getLength() == 1) {
                return this.item(0).matches(syntax);
            }
            if (syntax.getCategory() == CSSValueSyntax.Category.universal) {
                return CSSValueSyntax.Match.TRUE;
            }
            do {
                CSSValueSyntax.Multiplier mult;
                if ((mult = syntax.getMultiplier()) == CSSValueSyntax.Multiplier.PLUS) continue;
                CSSValueSyntax.Match match = ValueList.valuesMatch(this.iterator(), syntax);
                if (match == CSSValueSyntax.Match.TRUE) {
                    return CSSValueSyntax.Match.TRUE;
                }
                if (result != CSSValueSyntax.Match.FALSE) continue;
                result = match;
            } while ((syntax = syntax.getNext()) != null);
        }
        return result;
    }
}

