/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticatorFactory;
import org.keycloak.authentication.authenticators.conditional.ConditionalCredentialAuthenticator;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class ConditionalCredentialAuthenticatorFactory
implements ConditionalAuthenticatorFactory {
    public static final String PROVIDER_ID = "conditional-credential";
    public static final String CONF_CREDENTIALS = "credentials";
    public static final String CONF_INCLUDED = "included";
    public static final String NONE_CREDENTIAL = "none";
    private List<String> credentialList;

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory sessionFactory) {
        this.credentialList = ConditionalCredentialAuthenticatorFactory.getCredentialList(sessionFactory);
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Condition - credential";
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Condition to evaluate if a specific credential type has been used (or not used) by the user during the authentication process";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name(CONF_CREDENTIALS).type("MultivaluedList").options(this.credentialList).label("Credentials").helpText("The list of credentials to be considered by the condition.").required(Boolean.TRUE.booleanValue()).add().property().name(CONF_INCLUDED).type("boolean").label("Included").helpText("If this option is true, the condition will be evaluated to true when any of the credentials specified in the credentials option\nhas been used in the authentication process, false otherwise.\nIf this option is false, the condition is evaluated in the opposite way, it will be true if none of the credentials configured\nhave been used, and false if one or more of them have been used.\n").add().build();
    }

    @Override
    public ConditionalAuthenticator getSingleton() {
        return ConditionalCredentialAuthenticator.SINGLETON;
    }

    private static List<String> getCredentialList(KeycloakSessionFactory sessionFactory) {
        try (KeycloakSession session = sessionFactory.create();){
            List<String> list = Stream.concat(AuthenticatorUtil.getCredentialProviders(session).map(CredentialProvider::getType), Stream.of("kerberos", "cert", NONE_CREDENTIAL)).collect(Collectors.toList());
            return list;
        }
    }
}

