/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.resetcred;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.authentication.authenticators.resetcred.AbstractSetRequiredActionAuthenticator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.OTPCredentialProvider;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class ResetOTP
extends AbstractSetRequiredActionAuthenticator
implements CredentialValidator<OTPCredentialProvider> {
    public static final String PROVIDER_ID = "reset-otp";
    private static final String ACTION_ON_OTP_RESET_FLAG = "action_on_otp_reset_flag";
    private static final String REMOVE_NONE = "Remove none";
    private static final String REMOVE_ONE = "Remove one";
    private static final String REMOVE_ALL = "Remove all";

    public void authenticate(AuthenticationFlowContext context) {
        AuthenticatorConfigModel authenticatorConfigModel = context.getAuthenticatorConfig();
        Map authenticatorConfig = null;
        if (authenticatorConfigModel != null) {
            authenticatorConfig = authenticatorConfigModel.getConfig();
        }
        if (authenticatorConfig != null) {
            String selectedOption = (String)authenticatorConfig.get(ACTION_ON_OTP_RESET_FLAG);
            List<CredentialModel> otpCredentialModelList = context.getUser().credentialManager().getStoredCredentialsByTypeStream("otp").collect(Collectors.toList());
            if (REMOVE_ALL.equals(selectedOption)) {
                otpCredentialModelList.forEach(otpCredentialModel -> context.getUser().credentialManager().removeStoredCredentialById(otpCredentialModel.getId()));
            } else if (REMOVE_ONE.equals(selectedOption) && !otpCredentialModelList.isEmpty()) {
                Response challengeResponse = context.form().setAttribute("configuredOtpCredentials", otpCredentialModelList).createOtpReset();
                context.challenge(challengeResponse);
                return;
            }
        }
        context.getAuthenticationSession().addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        context.success();
    }

    @Override
    public void action(AuthenticationFlowContext context) {
        MultivaluedMap inputData = context.getHttpRequest().getDecodedFormParameters();
        String credentialId = (String)inputData.getFirst((Object)"selectedCredentialId");
        if (credentialId == null || credentialId.isEmpty()) {
            List otpCredentialModelList = context.getUser().credentialManager().getStoredCredentialsByTypeStream("otp").collect(Collectors.toList());
            Response challengeResponse = context.form().setAttribute("configuredOtpCredentials", otpCredentialModelList).setError("error-reset-otp-missing-id", new Object[0]).createOtpReset();
            context.challenge(challengeResponse);
            return;
        }
        context.getUser().credentialManager().removeStoredCredentialById(credentialId);
        context.getAuthenticationSession().addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        context.success();
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        builder.property(ACTION_ON_OTP_RESET_FLAG, "Action on OTP reset.", " If 'Remove none' is chosen, the user will keep all existing OTP configurations (legacy behavior). If 'Remove one' is chosen, the user will be prompted to choose one OTP configuration which will then be removed. If 'Remove all' is chosen, all existing OTP configurations of the user will be removed. The user will always be prompted to configure a new OTP no matter which option is selected.", "List", (Object)REMOVE_NONE, Arrays.asList(REMOVE_NONE, REMOVE_ONE, REMOVE_ALL));
        return builder.build();
    }

    public OTPCredentialProvider getCredentialProvider(KeycloakSession session) {
        return (OTPCredentialProvider)session.getProvider(CredentialProvider.class, "keycloak-otp");
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return this.getCredentialProvider(session).isConfiguredFor(realm, user);
    }

    public String getDisplayType() {
        return "Reset OTP";
    }

    public String getHelpText() {
        return "Removes existing OTP configurations (if chosen) and sets the 'Configure OTP' required action.";
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

