/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.protocol.HttpContext;
import org.jboss.logging.Logger;
import org.keycloak.connections.httpclient.ProxyMappings;

public class ProxyMappingsAwareRoutePlanner
extends DefaultRoutePlanner {
    private static final Logger LOG = Logger.getLogger(ProxyMappingsAwareRoutePlanner.class);
    private final ProxyMappings proxyMappings;

    public ProxyMappingsAwareRoutePlanner(ProxyMappings proxyMappings) {
        super((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
        this.proxyMappings = proxyMappings;
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        String targetHostName = target.getHostName();
        ProxyMappings.ProxyMapping proxyMapping = this.proxyMappings.getProxyFor(targetHostName);
        LOG.debugf("Returning proxyMapping=%s for targetHost=%s", (Object)proxyMapping, (Object)targetHostName);
        UsernamePasswordCredentials proxyCredentials = proxyMapping.getProxyCredentials();
        HttpHost proxyHost = proxyMapping.getProxyHost();
        if (proxyCredentials != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(proxyHost.getHostName(), proxyHost.getPort()), (Credentials)proxyCredentials);
            context.setAttribute("http.auth.credentials-provider", (Object)credsProvider);
        }
        return proxyHost;
    }
}

