/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.filters;

import jakarta.annotation.Priority;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.List;
import org.jboss.logging.Logger;

@Provider
@PreMatching
@Priority(value=10)
public class InvalidQueryParameterFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = Logger.getLogger(InvalidQueryParameterFilter.class);
    private static final String NUL_CHARACTER = "\u0000";

    public void filter(ContainerRequestContext requestContext) throws IOException {
        MultivaluedMap queryParams = requestContext.getUriInfo().getQueryParameters();
        for (List queryParamValues : queryParams.values()) {
            for (String queryParamValue : queryParamValues) {
                if (!this.containsAnyNULCharacter(queryParamValue)) continue;
                LOGGER.debugf("Request with invalid query parameter value is blocked", new Object[0]);
                throw new BadRequestException("Blocking invalid query parameter value");
            }
        }
    }

    private boolean containsAnyNULCharacter(String input) {
        if (input == null) {
            return false;
        }
        return input.contains(NUL_CHARACTER);
    }
}

