/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.AnnotationCreator;
import io.quarkus.gizmo.AnnotationCreatorImpl;
import io.quarkus.gizmo.AnnotationUtils;
import io.quarkus.gizmo.BytecodeCreatorImpl;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.ClassSignatureBuilderImpl;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldCreatorImpl;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.GizmoClassVisitor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodCreatorImpl;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.SignatureBuilder;
import io.quarkus.gizmo.SignatureElement;
import io.quarkus.gizmo.Type;
import java.io.Writer;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class ClassCreator
implements AutoCloseable,
AnnotatedElement,
SignatureElement<ClassCreator> {
    private final BytecodeCreatorImpl enclosing;
    private final ClassOutput classOutput;
    private final String superClass;
    private final int access;
    private final String[] interfaces;
    private final Map<MethodDescriptor, MethodCreatorImpl> methods = new LinkedHashMap<MethodDescriptor, MethodCreatorImpl>();
    private final Map<FieldDescriptor, FieldCreatorImpl> fields = new LinkedHashMap<FieldDescriptor, FieldCreatorImpl>();
    private final List<AnnotationCreatorImpl> annotations = new ArrayList<AnnotationCreatorImpl>();
    private final String className;
    private String signature;
    private final Map<MethodDescriptor, MethodDescriptor> superclassAccessors = new LinkedHashMap<MethodDescriptor, MethodDescriptor>();
    private final AtomicInteger accessorCount = new AtomicInteger();

    public static Builder builder() {
        return new Builder(4129);
    }

    public static Builder interfaceBuilder() {
        return new Builder(5633);
    }

    ClassCreator(BytecodeCreatorImpl enclosing, ClassOutput classOutput, String name, String signature, String superClass, int access, String ... interfaces) {
        this.enclosing = enclosing;
        this.classOutput = classOutput;
        this.superClass = superClass.replace('.', '/');
        this.access = access;
        this.interfaces = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            this.interfaces[i] = interfaces[i].replace('.', '/');
        }
        this.className = name.replace('.', '/');
        this.signature = signature;
    }

    public ClassCreator(ClassOutput classOutput, String name, String signature, String superClass, String ... interfaces) {
        this(null, classOutput, name, signature, superClass, 4129, interfaces);
    }

    public MethodCreator getConstructorCreator(String ... parameters) {
        return this.getMethodCreator("<init>", "V", parameters);
    }

    public MethodCreator getConstructorCreator(Class<?> ... parameters) {
        return this.getMethodCreator("<init>", Void.TYPE, parameters);
    }

    public MethodCreator getMethodCreator(MethodDescriptor methodDescriptor) {
        if (this.isInterface() && "<init>".equals(methodDescriptor.getName())) {
            throw new IllegalArgumentException("Constructor may not be declared on an interface: " + methodDescriptor);
        }
        if (this.methods.containsKey(methodDescriptor)) {
            return this.methods.get(methodDescriptor);
        }
        MethodCreatorImpl creator = new MethodCreatorImpl(this.enclosing, methodDescriptor, this.className, this);
        this.methods.put(methodDescriptor, creator);
        return creator;
    }

    public MethodCreator getMethodCreator(String name, String returnType, String ... parameters) {
        return this.getMethodCreator(MethodDescriptor.ofMethod(this.className, name, returnType, parameters));
    }

    public MethodCreator getMethodCreator(String name, Class<?> returnType, Class<?> ... parameters) {
        String[] params = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            params[i] = DescriptorUtils.classToStringRepresentation(parameters[i]);
        }
        return this.getMethodCreator(name, DescriptorUtils.classToStringRepresentation(returnType), params);
    }

    public MethodCreator getMethodCreator(String name, Object returnType, Object ... parameters) {
        return this.getMethodCreator(MethodDescriptor.ofMethod((Object)this.className, name, returnType, parameters));
    }

    public FieldCreator getFieldCreator(String name, String type) {
        return this.getFieldCreator(FieldDescriptor.of(this.className, name, type));
    }

    public FieldCreator getFieldCreator(String name, Object type) {
        return this.getFieldCreator(FieldDescriptor.of(this.className, name, DescriptorUtils.objectToDescriptor(type)));
    }

    public FieldCreator getFieldCreator(FieldDescriptor fieldDescriptor) {
        FieldCreatorImpl field = this.fields.get(fieldDescriptor);
        if (field == null) {
            field = new FieldCreatorImpl(fieldDescriptor, this.isInterface());
            this.fields.put(fieldDescriptor, field);
        }
        return field;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSimpleClassName() {
        int index = this.className.lastIndexOf(47);
        return index < 0 ? this.className : this.className.substring(index + 1);
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    MethodDescriptor getSupertypeAccessor(MethodDescriptor descriptor, String supertype, boolean isInterface) {
        if (this.superclassAccessors.containsKey(descriptor)) {
            return this.superclassAccessors.get(descriptor);
        }
        String name = descriptor.getName() + "$$superaccessor" + this.accessorCount.incrementAndGet();
        MethodCreator ctor = this.getMethodCreator(name, descriptor.getReturnType(), descriptor.getParameterTypes());
        ResultHandle[] params = new ResultHandle[descriptor.getParameterTypes().length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = ctor.getMethodParam(i);
        }
        MethodDescriptor superDescriptor = MethodDescriptor.ofMethod(supertype, descriptor.getName(), descriptor.getReturnType(), descriptor.getParameterTypes());
        ResultHandle ret = isInterface ? ctor.invokeSpecialInterfaceMethod(superDescriptor, ctor.getThis(), params) : ctor.invokeSpecialMethod(superDescriptor, ctor.getThis(), params);
        ctor.returnValue(ret);
        this.superclassAccessors.put(descriptor, ctor.getMethodDescriptor());
        return ctor.getMethodDescriptor();
    }

    public void writeTo(ClassOutput classOutput) {
        Objects.requireNonNull(classOutput);
        ClassWriter file = new ClassWriter(3);
        Writer sourceWriter = classOutput.getSourceWriter(this.className);
        Object cv = sourceWriter != null ? new GizmoClassVisitor(589824, (ClassVisitor)file, sourceWriter) : file;
        String[] interfaces = (String[])this.interfaces.clone();
        cv.visit(55, this.access, this.className, this.signature, this.superClass, interfaces);
        cv.visitSource(null, null);
        boolean requiresCtor = !this.isInterface();
        for (MethodDescriptor methodDescriptor : this.methods.keySet()) {
            if (!methodDescriptor.getName().equals("<init>")) continue;
            requiresCtor = false;
            break;
        }
        if (requiresCtor) {
            if (cv instanceof GizmoClassVisitor) {
                ((GizmoClassVisitor)((Object)cv)).append("// Auto-generated constructor").newLine();
            }
            MethodVisitor mv = cv.visitMethod(1, "<init>", "()V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, this.superClass, "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 1);
            mv.visitEnd();
        }
        for (Map.Entry entry : this.fields.entrySet()) {
            ((FieldCreatorImpl)entry.getValue()).write((ClassVisitor)cv);
        }
        for (Map.Entry entry : this.methods.entrySet()) {
            ((MethodCreatorImpl)entry.getValue()).write((ClassVisitor)cv);
        }
        for (AnnotationCreatorImpl annotationCreatorImpl : this.annotations) {
            AnnotationVisitor av = cv.visitAnnotation(DescriptorUtils.extToInt(annotationCreatorImpl.getAnnotationType()), annotationCreatorImpl.getRetentionPolicy() == RetentionPolicy.RUNTIME);
            for (Map.Entry<String, Object> e : annotationCreatorImpl.getValues().entrySet()) {
                AnnotationUtils.visitAnnotationValue(av, e.getKey(), e.getValue());
            }
            av.visitEnd();
        }
        cv.visitEnd();
        classOutput.write(this.className, file.toByteArray());
    }

    @Override
    public void close() {
        ClassOutput classOutput = this.classOutput;
        if (classOutput != null) {
            this.writeTo(classOutput);
        }
    }

    @Override
    public AnnotationCreator addAnnotation(String annotationType, RetentionPolicy retentionPolicy) {
        AnnotationCreatorImpl ac = new AnnotationCreatorImpl(annotationType, retentionPolicy);
        this.annotations.add(ac);
        return ac;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public ClassCreator setSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public Set<MethodDescriptor> getExistingMethods() {
        return this.methods.keySet();
    }

    public Set<FieldDescriptor> getExistingFields() {
        return this.fields.keySet();
    }

    ClassOutput getClassOutput() {
        return this.classOutput;
    }

    public static class Builder {
        private ClassOutput classOutput;
        private String className;
        private String signature;
        private String superClass;
        private final List<String> interfaces;
        private BytecodeCreatorImpl enclosing;
        private int access;

        Builder(int access) {
            this.superClass(Object.class);
            this.access = access;
            this.interfaces = new ArrayList<String>();
        }

        Builder enclosing(BytecodeCreatorImpl enclosing) {
            this.enclosing = enclosing;
            return this;
        }

        public Builder classOutput(ClassOutput classOutput) {
            this.classOutput = classOutput;
            return this;
        }

        public Builder className(String className) {
            this.className = className;
            return this;
        }

        public Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public Builder signature(SignatureBuilder.ClassSignatureBuilder signatureBuilder) {
            ClassSignatureBuilderImpl signatureBuilderImpl = (ClassSignatureBuilderImpl)signatureBuilder;
            Type superClass = signatureBuilderImpl.superClass;
            if (superClass != null) {
                this.superClass(this.getRawType(superClass));
            }
            if (!signatureBuilderImpl.superInterfaces.isEmpty()) {
                String[] interfaces = new String[signatureBuilderImpl.superInterfaces.size()];
                int idx = 0;
                for (Type superInterface : signatureBuilderImpl.superInterfaces) {
                    interfaces[idx++] = this.getRawType(superInterface);
                }
                this.interfaces(interfaces);
            }
            return this.signature(signatureBuilder.build());
        }

        public Builder superClass(String superClass) {
            if ((this.access & 0x200) != 0 && !"java.lang.Object".equals(superClass) && !"java/lang/Object".equals(superClass)) {
                throw new IllegalArgumentException("Interface may only have java.lang.Object as a superclass: " + this.className);
            }
            this.superClass = superClass;
            return this;
        }

        public Builder superClass(Class<?> superClass) {
            return this.superClass(superClass.getName());
        }

        public Builder setFinal(boolean isFinal) {
            if ((this.access & 0x200) != 0 && isFinal) {
                throw new IllegalArgumentException("Interface may not be final: " + this.className);
            }
            this.access = isFinal ? (this.access |= 0x10) : (this.access &= 0xFFFFFFEF);
            return this;
        }

        public Builder interfaces(String ... interfaces) {
            Collections.addAll(this.interfaces, interfaces);
            return this;
        }

        public Builder interfaces(Class<?> ... interfaces) {
            for (Class<?> val : interfaces) {
                this.interfaces.add(val.getName());
            }
            return this;
        }

        public ClassCreator build() {
            Objects.requireNonNull(this.className);
            Objects.requireNonNull(this.superClass);
            return new ClassCreator(this.enclosing, this.classOutput, this.className, this.signature, this.superClass, this.access, this.interfaces.toArray(new String[0]));
        }

        private String getRawType(Type type) {
            if (type.isClass()) {
                return type.asClass().name;
            }
            return type.asParameterizedType().genericClass.name;
        }
    }
}

