/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jgroups.header;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jgroups.Header;
import org.jgroups.util.Util;

public class TracerHeader
extends Header {
    public static final short ID = 1050;
    protected final Map<String, String> ctx = new HashMap<String, String>();

    public short getMagicId() {
        return 1050;
    }

    public Supplier<? extends Header> create() {
        return TracerHeader::new;
    }

    public void put(String key, String value) {
        this.ctx.put(key, value);
    }

    public String get(String key) {
        return this.ctx.get(key);
    }

    public Set<String> keys() {
        return this.ctx.keySet();
    }

    public int serializedSize() {
        int size = 4;
        int num_attrs = this.ctx.size();
        if (num_attrs > 0) {
            for (Map.Entry<String, String> entry : this.ctx.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                size += Util.size((String)key) + Util.size((String)val);
            }
        }
        return size;
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeInt(this.ctx.size());
        if (!this.ctx.isEmpty()) {
            for (Map.Entry<String, String> e : this.ctx.entrySet()) {
                Util.writeString((String)e.getKey(), (DataOutput)out);
                Util.writeString((String)e.getValue(), (DataOutput)out);
            }
        }
    }

    public void readFrom(DataInput in) throws IOException {
        int size = in.readInt();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                this.ctx.put(Util.readString((DataInput)in), Util.readString((DataInput)in));
            }
        }
    }

    public String toString() {
        return this.ctx.toString();
    }
}

