/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.internal.MultimapObjectWrapper;

public interface SortableBucket<V> {
    public Stream<MultimapObjectWrapper<V>> stream();

    public List<ScoredValue<V>> sort(SortOptions var1);

    default public List<ScoredValue<V>> sort(Stream<ScoredValue<V>> scoredValueStream, SortOptions options) {
        if (!options.skipSort) {
            scoredValueStream = scoredValueStream.sorted(options.asc ? Comparator.naturalOrder() : Comparator.reverseOrder());
        } else if (options.skipSort && !options.asc) {
            ArrayDeque reverse = new ArrayDeque();
            scoredValueStream.forEach(v -> reverse.offerFirst(v));
            scoredValueStream = reverse.stream();
        }
        return scoredValueStream.skip(options.offset).limit(options.count < 0L ? Long.MAX_VALUE : options.count).collect(Collectors.toList());
    }

    public static class SortOptions {
        public boolean alpha = false;
        public boolean asc = true;
        public long offset = 0L;
        public long count = -1L;
        public boolean skipSort;
    }
}

