/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.msad;

import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.msad.MSADUserAccountControlStorageMapper;

public class MSADUserAccountControlStorageMapperFactory
extends AbstractLDAPStorageMapperFactory {
    public static final String PROVIDER_ID = "msad-user-account-control-mapper";
    protected static final List<ProviderConfigProperty> configProperties = MSADUserAccountControlStorageMapperFactory.getConfigProps(null);

    private static List<ProviderConfigProperty> getConfigProps(ComponentModel parentModel) {
        UserStorageProviderModel parent = parentModel != null ? new UserStorageProviderModel(parentModel) : new UserStorageProviderModel();
        ProviderConfigurationBuilder config = ProviderConfigurationBuilder.create().property().name("ldap.password.policy.hints.enabled").label("Password Policy Hints Enabled").helpText("Applicable just for writable MSAD. If on, then updating password of MSAD user will use LDAP_SERVER_POLICY_HINTS_OID extension, which means that advanced MSAD password policies like 'password history' or 'minimal password age' will be applied. This extension works just for MSAD 2008 R2 or newer.").type("boolean").defaultValue((Object)"false").add();
        if (parent.isImportEnabled()) {
            config.property().name("always.read.enabled.value.from.ldap").label("Always Read Enabled Value From LDAP").helpText("If on, the user enabled/disabled state will always be read from MSAD by checking the proper userAccountControl").type("boolean").defaultValue((Object)"false").add();
        }
        return config.build();
    }

    @Override
    public String getHelpText() {
        return "Mapper specific to MSAD. It's able to integrate the MSAD user account state into Keycloak account state (account enabled, password is expired etc). It's using userAccountControl and pwdLastSet MSAD attributes for that. For example if pwdLastSet is 0, the Keycloak user is required to update password, if userAccountControl is 514 (disabled account) the Keycloak user is disabled as well etc. Mapper is also able to handle exception code from LDAP user authentication.";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public List<ProviderConfigProperty> getConfigProperties(RealmModel realm, ComponentModel parent) {
        return MSADUserAccountControlStorageMapperFactory.getConfigProps(parent);
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    protected AbstractLDAPStorageMapper createMapper(ComponentModel mapperModel, LDAPStorageProvider federationProvider) {
        return new MSADUserAccountControlStorageMapper(mapperModel, federationProvider);
    }
}

