/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;

public class OrientedCoordinateArray
implements Comparable {
    private Coordinate[] pts;
    private boolean orientation;

    public OrientedCoordinateArray(Coordinate[] pts) {
        this.pts = pts;
        this.orientation = OrientedCoordinateArray.orientation(pts);
    }

    private static boolean orientation(Coordinate[] pts) {
        return CoordinateArrays.increasingDirection(pts) == 1;
    }

    public int compareTo(Object o1) {
        OrientedCoordinateArray oca = (OrientedCoordinateArray)o1;
        int comp = OrientedCoordinateArray.compareOriented(this.pts, this.orientation, oca.pts, oca.orientation);
        return comp;
    }

    private static int compareOriented(Coordinate[] pts1, boolean orientation1, Coordinate[] pts2, boolean orientation2) {
        boolean done2;
        boolean done1;
        int i2;
        int dir1 = orientation1 ? 1 : -1;
        int dir2 = orientation2 ? 1 : -1;
        int limit1 = orientation1 ? pts1.length : -1;
        int limit2 = orientation2 ? pts2.length : -1;
        int i1 = orientation1 ? 0 : pts1.length - 1;
        int n = i2 = orientation2 ? 0 : pts2.length - 1;
        do {
            int compPt;
            if ((compPt = pts1[i1].compareTo(pts2[i2])) != 0) {
                return compPt;
            }
            done1 = (i1 += dir1) == limit1;
            boolean bl = done2 = (i2 += dir2) == limit2;
            if (done1 && !done2) {
                return -1;
            }
            if (done1 || !done2) continue;
            return 1;
        } while (!done1 || !done2);
        return 0;
    }
}

