/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.quarkus.micrometer.runtime.binder.RequestMetricInfo;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Pattern;

public class HttpRequestMetric
extends RequestMetricInfo {
    public static final Pattern VERTX_ROUTE_PARAM = Pattern.compile("^:(.*)$");
    static final ConcurrentHashMap<String, String> vertxWebToUriTemplate = new ConcurrentHashMap();
    private HttpServerRequestInternal request;
    private String initialPath;
    private String templatePath;
    private String currentRoutePath;
    private final LongAdder activeRequests;
    private boolean requestActive = false;

    public HttpRequestMetric(String uri, LongAdder activeRequests) {
        this.initialPath = uri;
        this.activeRequests = activeRequests;
    }

    public HttpRequestMetric(HttpRequest request, LongAdder activeRequests) {
        this.request = (HttpServerRequestInternal)request;
        this.initialPath = this.request.path();
        this.activeRequests = activeRequests;
    }

    public String getNormalizedUriPath(Map<Pattern, String> matchPatterns, List<Pattern> ignorePatterns) {
        if (this.isCORSPreflightRequest()) {
            return HttpRequestMetric.filterIgnored("/cors-preflight", ignorePatterns);
        }
        return super.getNormalizedUriPath(matchPatterns, ignorePatterns, this.initialPath);
    }

    public String getInitialPath() {
        return this.initialPath;
    }

    @Override
    public String applyTemplateMatching(String path) {
        String urlTemplatePath = this.getUrlTemplatePath();
        if (urlTemplatePath != null) {
            return HttpRequestMetric.normalizePath(urlTemplatePath);
        }
        if (this.currentRoutePath != null && this.currentRoutePath.contains(":")) {
            return vertxWebToUriTemplate.computeIfAbsent(this.currentRoutePath, k -> {
                CharSequence[] segments = k.split("/");
                for (int i = 0; i < segments.length; ++i) {
                    segments[i] = VERTX_ROUTE_PARAM.matcher(segments[i]).replaceAll("{$1}");
                }
                return HttpRequestMetric.normalizePath(String.join((CharSequence)"/", segments));
            });
        }
        return path;
    }

    public HttpServerRequestInternal request() {
        return this.request;
    }

    public void requestStarted() {
        if (!this.requestActive) {
            this.requestActive = true;
            this.activeRequests.increment();
        }
    }

    public void requestEnded() {
        if (this.requestActive) {
            this.requestActive = false;
            this.activeRequests.decrement();
        }
    }

    public void setTemplatePath(String path) {
        if (this.templatePath == null) {
            this.templatePath = path;
        }
    }

    public void appendCurrentRoutePath(String path) {
        if (path != null && !path.isEmpty()) {
            this.currentRoutePath = path;
        }
    }

    public static HttpRequestMetric getRequestMetric(RoutingContext context) {
        HttpServerRequestInternal internalRequest = (HttpServerRequestInternal)context.request();
        return (HttpRequestMetric)internalRequest.metric();
    }

    String getUrlTemplatePath() {
        String urlTemplatePath = null;
        if (this.request != null) {
            urlTemplatePath = (String)this.request.context().getLocal((Object)"UrlPathTemplate");
        }
        return urlTemplatePath == null ? this.templatePath : urlTemplatePath;
    }

    public String toString() {
        return "HttpRequestMetric [initialPath=" + this.initialPath + ", currentRoutePath=" + this.currentRoutePath + ", templatePath=" + this.templatePath + ", request=" + String.valueOf(this.request) + "]";
    }

    private boolean isCORSPreflightRequest() {
        return this.request.method() == HttpMethod.OPTIONS && this.request.getHeader("Origin") != null && this.request.getHeader("Access-Control-Request-Method") != null && this.request.getHeader("Access-Control-Request-Headers") != null;
    }
}

