/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.cmd;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.cmd.RunCommandActionBuildItem;
import io.quarkus.deployment.cmd.RunCommandActionResultBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RunCommandProcessor {
    private static final String JAVA_HOME_SYS = "java.home";
    private static final String JAVA_HOME_ENV = "JAVA_HOME";

    @BuildStep
    public RunCommandActionResultBuildItem commands(List<RunCommandActionBuildItem> cmds) {
        return new RunCommandActionResultBuildItem(cmds);
    }

    @BuildStep
    public void defaultJavaCommand(PackageConfig packageConfig, OutputTargetBuildItem jar, BuildProducer<RunCommandActionBuildItem> cmds, BuildSystemTargetBuildItem buildSystemTarget) {
        Path jarPath = switch (packageConfig.jar().type()) {
            default -> throw new IncompatibleClassChangeError();
            case PackageConfig.JarConfig.JarType.UBER_JAR -> jar.getOutputDirectory().resolve(jar.getBaseName() + packageConfig.computedRunnerSuffix() + ".jar");
            case PackageConfig.JarConfig.JarType.LEGACY_JAR -> jar.getOutputDirectory().resolve(jar.getBaseName() + packageConfig.computedRunnerSuffix() + ".jar");
            case PackageConfig.JarConfig.JarType.FAST_JAR, PackageConfig.JarConfig.JarType.MUTABLE_JAR -> jar.getOutputDirectory().resolve("quarkus-app").resolve("quarkus-run.jar");
        };
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.determineJavaPath());
        for (Map.Entry<Object, Object> e : buildSystemTarget.getBuildSystemProps().entrySet()) {
            args.add("-D" + e.getKey().toString() + "=" + e.getValue().toString());
        }
        args.add("-jar");
        args.add(jarPath.toAbsolutePath().toString());
        cmds.produce(new RunCommandActionBuildItem("java", args, null, null, null, false));
    }

    private String determineJavaPath() {
        File javaHome;
        File file;
        String home = System.getProperty(JAVA_HOME_SYS);
        if (home == null) {
            home = System.getenv(JAVA_HOME_ENV);
        }
        if (home != null && (file = new File(javaHome = new File(home), "bin/java")).exists()) {
            return file.getAbsolutePath();
        }
        return "java";
    }
}

