/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.services.health;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceMetrics;
import io.quarkus.agroal.runtime.health.DataSourceHealthCheck;
import io.quarkus.smallrye.health.runtime.QuarkusAsyncHealthCheckFactory;
import io.smallrye.health.api.AsyncHealthCheck;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class KeycloakReadyHealthCheck
implements AsyncHealthCheck {
    public static final String FAILING_SINCE = "Failing since";
    static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS").withZone(ZoneId.systemDefault());
    @Inject
    AgroalDataSource agroalDataSource;
    @Inject
    QuarkusAsyncHealthCheckFactory healthCheckFactory;
    @Inject
    DataSourceHealthCheck dataSourceHealthCheck;
    private final AtomicReference<Instant> failingSince = new AtomicReference();

    public Uni<HealthCheckResponse> call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Keycloak database connections async health check").up();
        AgroalDataSourceMetrics metrics = this.agroalDataSource.getMetrics();
        long activeCount = metrics.activeCount();
        long invalidCount = metrics.invalidCount();
        if (activeCount < 1L || invalidCount > 0L) {
            return this.healthCheckFactory.callSync(() -> {
                HealthCheckResponse activeCheckResult = this.dataSourceHealthCheck.call();
                if (activeCheckResult.getStatus() == HealthCheckResponse.Status.DOWN) {
                    builder.down();
                    Instant failingTime = this.failingSince.updateAndGet(KeycloakReadyHealthCheck::createInstanceIfNeeded);
                    builder.withData(FAILING_SINCE, DATE_FORMATTER.format(failingTime));
                } else {
                    this.failingSince.set(null);
                }
                return builder.build();
            });
        }
        this.failingSince.set(null);
        return this.healthCheckFactory.callAsync(() -> Uni.createFrom().item((Object)builder.build()));
    }

    static Instant createInstanceIfNeeded(Instant instant) {
        return Objects.requireNonNullElseGet(instant, Instant::now);
    }
}

