/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.jdk8.FlowableFromCompletionStage;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;

public final class CompletableFromCompletionStage<T>
extends Completable {
    final CompletionStage<T> stage;

    public CompletableFromCompletionStage(CompletionStage<T> stage) {
        this.stage = stage;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        FlowableFromCompletionStage.BiConsumerAtomicReference whenReference = new FlowableFromCompletionStage.BiConsumerAtomicReference();
        CompletionStageHandler handler = new CompletionStageHandler(observer, whenReference);
        whenReference.lazySet(handler);
        observer.onSubscribe(handler);
        this.stage.whenComplete(whenReference);
    }

    static final class CompletionStageHandler<T>
    implements Disposable,
    BiConsumer<T, Throwable> {
        final CompletableObserver downstream;
        final FlowableFromCompletionStage.BiConsumerAtomicReference<T> whenReference;

        CompletionStageHandler(CompletableObserver downstream, FlowableFromCompletionStage.BiConsumerAtomicReference<T> whenReference) {
            this.downstream = downstream;
            this.whenReference = whenReference;
        }

        @Override
        public void accept(T item, Throwable error) {
            if (error != null) {
                this.downstream.onError(error);
            } else {
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.whenReference.set(null);
        }

        @Override
        public boolean isDisposed() {
            return this.whenReference.get() == null;
        }
    }
}

