/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Convert;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinTable;
import jakarta.persistence.MappedSuperclass;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.boot.model.internal.AbstractPropertyHolder;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AttributeConversionInfo;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;

public class ClassPropertyHolder
extends AbstractPropertyHolder {
    private final PersistentClass persistentClass;
    private Map<String, Join> joins;
    private transient Map<String, Join> joinsPerRealTableName;
    private EntityBinder entityBinder;
    private final Map<ClassDetails, InheritanceState> inheritanceStatePerClass;
    private final Map<String, AttributeConversionInfo> attributeConversionInfoMap;
    public static final String ACCESS_PROPERTY = "property";
    public static final String ACCESS_FIELD = "field";
    public static final String ACCESS_RECORD = "record";

    public ClassPropertyHolder(PersistentClass persistentClass, ClassDetails entityXClass, Map<String, Join> joins, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass) {
        super(persistentClass.getEntityName(), null, entityXClass, context);
        this.persistentClass = persistentClass;
        this.joins = joins;
        this.inheritanceStatePerClass = inheritanceStatePerClass;
        this.attributeConversionInfoMap = this.buildAttributeConversionInfoMap(entityXClass);
    }

    public ClassPropertyHolder(PersistentClass persistentClass, ClassDetails entityXClass, EntityBinder entityBinder, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass) {
        this(persistentClass, entityXClass, entityBinder.getSecondaryTables(), context, inheritanceStatePerClass);
        this.entityBinder = entityBinder;
    }

    @Override
    protected String normalizeCompositePath(String attributeName) {
        return attributeName;
    }

    @Override
    protected String normalizeCompositePathForLogging(String attributeName) {
        return this.getEntityName() + "." + attributeName;
    }

    protected Map<String, AttributeConversionInfo> buildAttributeConversionInfoMap(ClassDetails entityClassDetails) {
        HashMap<String, AttributeConversionInfo> map = new HashMap<String, AttributeConversionInfo>();
        this.collectAttributeConversionInfo(map, entityClassDetails);
        return map;
    }

    private void collectAttributeConversionInfo(Map<String, AttributeConversionInfo> infoMap, ClassDetails entityClassDetails) {
        boolean canContainConvert;
        if (entityClassDetails == null) {
            return;
        }
        this.collectAttributeConversionInfo(infoMap, entityClassDetails.getSuperClass());
        boolean bl = canContainConvert = entityClassDetails.hasAnnotationUsage(Entity.class, this.getSourceModelContext()) || entityClassDetails.hasAnnotationUsage(MappedSuperclass.class, this.getSourceModelContext()) || entityClassDetails.hasAnnotationUsage(Embeddable.class, this.getSourceModelContext());
        if (!canContainConvert) {
            return;
        }
        entityClassDetails.forEachAnnotationUsage(Convert.class, this.getSourceModelContext(), usage -> {
            AttributeConversionInfo info = new AttributeConversionInfo((Convert)usage, (AnnotationTarget)entityClassDetails);
            if (StringHelper.isEmpty(info.getAttributeName())) {
                throw new IllegalStateException("@Convert placed on @Entity/@MappedSuperclass must define attributeName");
            }
            infoMap.put(info.getAttributeName(), info);
        });
    }

    @Override
    public void startingProperty(MemberDetails property) {
        if (property == null) {
            return;
        }
        String propertyName = property.resolveAttributeName();
        if (this.attributeConversionInfoMap.containsKey(propertyName)) {
            return;
        }
        property.forEachAnnotationUsage(Convert.class, this.getSourceModelContext(), usage -> {
            AttributeConversionInfo info = new AttributeConversionInfo((Convert)usage, (AnnotationTarget)property);
            String path = StringHelper.isEmpty(info.getAttributeName()) ? propertyName : propertyName + "." + info.getAttributeName();
            this.attributeConversionInfoMap.put(path, info);
        });
    }

    @Override
    protected AttributeConversionInfo locateAttributeConversionInfo(MemberDetails attributeMember) {
        return this.locateAttributeConversionInfo(attributeMember.resolveAttributeName());
    }

    @Override
    protected AttributeConversionInfo locateAttributeConversionInfo(String path) {
        return this.attributeConversionInfoMap.get(path);
    }

    @Override
    public String getEntityName() {
        return this.persistentClass.getEntityName();
    }

    @Override
    public void addProperty(Property prop, MemberDetails memberDetails, @Nullable AnnotatedColumns columns, ClassDetails declaringClass) {
        if (columns != null) {
            if (columns.isSecondary()) {
                this.addPropertyToJoin(prop, memberDetails, declaringClass, columns.getJoin());
            } else {
                this.addProperty(prop, memberDetails, declaringClass);
            }
        } else {
            this.addProperty(prop, memberDetails, declaringClass);
        }
    }

    @Override
    public void addProperty(Property prop, MemberDetails memberDetails, ClassDetails declaringClass) {
        if (prop.getValue() instanceof Component) {
            String tableName = prop.getValue().getTable().getName();
            if (this.getJoinsPerRealTableName().containsKey(tableName)) {
                Join join = this.getJoinsPerRealTableName().get(tableName);
                this.addPropertyToJoin(prop, memberDetails, declaringClass, join);
            } else {
                this.addPropertyToPersistentClass(prop, memberDetails, declaringClass);
            }
        } else {
            this.addPropertyToPersistentClass(prop, memberDetails, declaringClass);
        }
    }

    @Override
    public Join addJoin(JoinTable joinTableAnn, boolean noDelayInPkColumnCreation) {
        Join join = this.entityBinder.addJoinTable(joinTableAnn, this, noDelayInPkColumnCreation);
        this.joins = this.entityBinder.getSecondaryTables();
        return join;
    }

    @Override
    public Join addJoin(JoinTable joinTable, Table table, boolean noDelayInPkColumnCreation) {
        Join join = this.entityBinder.createJoin(this, noDelayInPkColumnCreation, false, joinTable.joinColumns(), table.getQualifiedTableName(), table);
        this.joins = this.entityBinder.getSecondaryTables();
        return join;
    }

    public static void handleGenericComponentProperty(Property property, MemberDetails memberDetails, MetadataBuildingContext context) {
        Component component;
        Value value = property.getValue();
        if (value instanceof Component && (component = (Component)value).isGeneric() && component.getPropertySpan() > 0 && context.getMetadataCollector().getGenericComponent(component.getComponentClass()) == null) {
            Component copy = component.copy();
            copy.setGeneric(false);
            copy.getProperties().clear();
            Map<String, MemberDetails> declaredMembers = ClassPropertyHolder.getDeclaredAttributeMembers(memberDetails.getType().determineRawClass(), component.getProperty(0).getPropertyAccessorName());
            for (Property prop : component.getProperties()) {
                MemberDetails declaredMember = declaredMembers.get(prop.getName());
                if (declaredMember == null) {
                    copy.addProperty(prop);
                    continue;
                }
                ClassPropertyHolder.prepareActualProperty(prop, declaredMember, true, context, copy::addProperty);
            }
            context.getMetadataCollector().registerGenericComponent(copy);
        }
    }

    private void addPropertyToPersistentClass(Property property, MemberDetails memberDetails, ClassDetails declaringClass) {
        ClassPropertyHolder.handleGenericComponentProperty(property, memberDetails, this.getContext());
        if (declaringClass != null) {
            InheritanceState inheritanceState = this.inheritanceStatePerClass.get(declaringClass);
            if (inheritanceState == null) {
                throw new AssertionFailure("Declaring class is not found in the inheritance state hierarchy: " + String.valueOf(declaringClass));
            }
            if (inheritanceState.isEmbeddableSuperclass()) {
                this.persistentClass.addMappedSuperclassProperty(property);
                ClassPropertyHolder.addPropertyToMappedSuperclass(property, memberDetails, declaringClass, this.getContext());
            } else {
                this.persistentClass.addProperty(property);
            }
        } else {
            this.persistentClass.addProperty(property);
        }
    }

    public static void addPropertyToMappedSuperclass(Property prop, MemberDetails memberDetails, ClassDetails declaringClass, MetadataBuildingContext context) {
        org.hibernate.mapping.MappedSuperclass superclass = context.getMetadataCollector().getMappedSuperclass(declaringClass.toJavaClass());
        ClassPropertyHolder.prepareActualProperty(prop, memberDetails, true, context, superclass::addDeclaredProperty);
    }

    static void prepareActualProperty(Property prop, final MemberDetails memberDetails, boolean allowCollections, MetadataBuildingContext context, Consumer<Property> propertyConsumer) {
        if (memberDetails.getDeclaringType().getGenericSuperType() == null) {
            propertyConsumer.accept(prop);
            return;
        }
        if (memberDetails.getType().isResolved()) {
            propertyConsumer.accept(prop);
            return;
        }
        Property actualProperty = prop.copy();
        actualProperty.setGeneric(true);
        actualProperty.setReturnedClassName(memberDetails.getType().getName());
        Value value = actualProperty.getValue().copy();
        if (value instanceof Collection) {
            final Collection collection = (Collection)value;
            if (!allowCollections) {
                throw new AssertionFailure("Collections are not allowed as identifier properties");
            }
            collection.setRole(memberDetails.getDeclaringType().getName() + "." + prop.getName());
            final Value originalValue = prop.getValue();
            context.getMetadataCollector().addSecondPass(new SecondPass(){

                public void doSecondPass(Map persistentClasses) throws MappingException {
                    Collection initializedCollection = (Collection)originalValue;
                    Value element = initializedCollection.getElement().copy();
                    ClassPropertyHolder.setTypeName(element, memberDetails.getElementType().getName());
                    if (initializedCollection instanceof IndexedCollection) {
                        IndexedCollection indexedCollection = (IndexedCollection)initializedCollection;
                        Value index = indexedCollection.getIndex().copy();
                        if (memberDetails.getMapKeyType() != null) {
                            ClassPropertyHolder.setTypeName(index, memberDetails.getMapKeyType().getName());
                        }
                        ((IndexedCollection)collection).setIndex(index);
                    }
                    collection.setElement(element);
                }
            });
        } else {
            ClassPropertyHolder.setTypeName(value, memberDetails.getType().getName());
        }
        if (value instanceof Component) {
            Component component = (Component)value;
            Class<?> componentClass = component.getComponentClass();
            if (component.isGeneric()) {
                actualProperty.setValue(context.getMetadataCollector().getGenericComponent(componentClass));
            } else if (componentClass == Object.class) {
                component.clearProperties();
            } else {
                Iterator<Property> propertyIterator = component.getProperties().iterator();
                while (propertyIterator.hasNext()) {
                    try {
                        propertyIterator.next().getGetter(componentClass);
                    }
                    catch (PropertyNotFoundException e) {
                        propertyIterator.remove();
                    }
                }
            }
        }
        actualProperty.setValue(value);
        propertyConsumer.accept(actualProperty);
    }

    private static Map<String, MemberDetails> getDeclaredAttributeMembers(ClassDetails declaringType, String accessType) {
        HashMap<String, MemberDetails> members = new HashMap<String, MemberDetails>();
        for (ClassDetails superclass = declaringType; superclass != null; superclass = superclass.getSuperClass()) {
            ClassPropertyHolder.applyAttributeMembers(superclass, accessType, members);
        }
        return members;
    }

    private static void applyAttributeMembers(ClassDetails classDetails, String accessType, Map<String, MemberDetails> members) {
        List collectedMembers = switch (accessType) {
            case ACCESS_FIELD -> classDetails.getFields();
            case ACCESS_PROPERTY -> classDetails.getMethods();
            case ACCESS_RECORD -> classDetails.getRecordComponents();
            default -> throw new IllegalArgumentException("Unknown access type " + accessType);
        };
        collectedMembers.stream().filter(MemberDetails::isPersistable).forEach(member -> members.put(member.resolveAttributeName(), (MemberDetails)member));
    }

    private static void setTypeName(Value value, String typeName) {
        if (value instanceof ToOne) {
            ToOne toOne = (ToOne)value;
            toOne.setReferencedEntityName(typeName);
            toOne.setTypeName(typeName);
        } else if (value instanceof Component) {
            Component component = (Component)value;
            if (!component.isGeneric()) {
                component.setComponentClassName(typeName);
            }
            if (component.getTypeName() != null) {
                component.setTypeName(typeName);
            }
        } else if (value instanceof SimpleValue) {
            SimpleValue simpleValue = (SimpleValue)value;
            simpleValue.setTypeName(typeName);
        }
    }

    private void addPropertyToJoin(Property property, MemberDetails memberDetails, ClassDetails declaringClass, Join join) {
        if (declaringClass != null) {
            InheritanceState inheritanceState = this.inheritanceStatePerClass.get(declaringClass);
            if (inheritanceState == null) {
                throw new AssertionFailure("Declaring class is not found in the inheritance state hierarchy: " + String.valueOf(declaringClass));
            }
            if (inheritanceState.isEmbeddableSuperclass()) {
                join.addMappedSuperclassProperty(property);
                ClassPropertyHolder.addPropertyToMappedSuperclass(property, memberDetails, declaringClass, this.getContext());
            } else {
                join.addProperty(property);
            }
        } else {
            join.addProperty(property);
        }
    }

    private Map<String, Join> getJoinsPerRealTableName() {
        if (this.joinsPerRealTableName == null) {
            this.joinsPerRealTableName = CollectionHelper.mapOfSize(this.joins.size());
            for (Join join : this.joins.values()) {
                this.joinsPerRealTableName.put(join.getTable().getName(), join);
            }
        }
        return this.joinsPerRealTableName;
    }

    @Override
    public String getClassName() {
        return this.persistentClass.getClassName();
    }

    @Override
    public String getEntityOwnerClassName() {
        return this.getClassName();
    }

    @Override
    public Table getTable() {
        return this.persistentClass.getTable();
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public boolean isEntity() {
        return true;
    }

    @Override
    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public KeyValue getIdentifier() {
        return this.persistentClass.getIdentifier();
    }

    @Override
    public boolean isOrWithinEmbeddedId() {
        return false;
    }

    @Override
    public boolean isWithinElementCollection() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getEntityName() + ")";
    }
}

