/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.internal;

import jakarta.persistence.AccessType;
import java.util.EnumSet;
import org.hibernate.annotations.CascadeType;
import org.hibernate.boot.spi.EffectiveMappingDefaults;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.CollectionClassification;

public class OverriddenMappingDefaults
implements EffectiveMappingDefaults {
    private final String implicitSchemaName;
    private final String implicitCatalogName;
    private final boolean implicitlyQuoteIdentifiers;
    private final String implicitIdColumnName;
    private final String implicitTenantIdColumnName;
    private final String implicitDiscriminatorColumnName;
    private final String implicitPackageName;
    private final boolean autoImportEnabled;
    private final AccessType implicitPropertyAccessType;
    private final String implicitPropertyAccessorName;
    private final boolean entitiesImplicitlyLazy;
    private final boolean pluralAttributesImplicitlyLazy;
    private final org.hibernate.cache.spi.access.AccessType implicitCacheAccessType;
    private final EnumSet<CascadeType> cascadeTypes;
    private final CollectionClassification implicitListClassification;

    public OverriddenMappingDefaults(String implicitSchemaName, String implicitCatalogName, boolean implicitlyQuoteIdentifiers, String implicitIdColumnName, String implicitTenantIdColumnName, String implicitDiscriminatorColumnName, String implicitPackageName, boolean autoImportEnabled, EnumSet<CascadeType> cascadeTypes, AccessType implicitPropertyAccessType, String implicitPropertyAccessorName, boolean entitiesImplicitlyLazy, boolean pluralAttributesImplicitlyLazy, org.hibernate.cache.spi.access.AccessType implicitCacheAccessType, CollectionClassification implicitListClassification) {
        this.implicitSchemaName = implicitSchemaName;
        this.implicitCatalogName = implicitCatalogName;
        this.implicitlyQuoteIdentifiers = implicitlyQuoteIdentifiers;
        this.implicitIdColumnName = implicitIdColumnName;
        this.implicitTenantIdColumnName = implicitTenantIdColumnName;
        this.implicitDiscriminatorColumnName = implicitDiscriminatorColumnName;
        this.implicitPackageName = implicitPackageName;
        this.autoImportEnabled = autoImportEnabled;
        this.cascadeTypes = cascadeTypes;
        this.implicitPropertyAccessType = implicitPropertyAccessType;
        this.implicitPropertyAccessorName = implicitPropertyAccessorName;
        this.entitiesImplicitlyLazy = entitiesImplicitlyLazy;
        this.pluralAttributesImplicitlyLazy = pluralAttributesImplicitlyLazy;
        this.implicitCacheAccessType = implicitCacheAccessType;
        this.implicitListClassification = implicitListClassification;
    }

    @Override
    public String getDefaultSchemaName() {
        return this.implicitSchemaName;
    }

    @Override
    public String getDefaultCatalogName() {
        return this.implicitCatalogName;
    }

    @Override
    public boolean isDefaultQuoteIdentifiers() {
        return this.implicitlyQuoteIdentifiers;
    }

    @Override
    public String getDefaultIdColumnName() {
        return this.implicitIdColumnName;
    }

    @Override
    public String getDefaultDiscriminatorColumnName() {
        return this.implicitDiscriminatorColumnName;
    }

    @Override
    public String getDefaultTenantIdColumnName() {
        return this.implicitTenantIdColumnName;
    }

    @Override
    public String getDefaultPackageName() {
        return this.implicitPackageName;
    }

    @Override
    public boolean isDefaultAutoImport() {
        return this.autoImportEnabled;
    }

    @Override
    public EnumSet<CascadeType> getDefaultCascadeTypes() {
        return this.cascadeTypes;
    }

    @Override
    public AccessType getDefaultPropertyAccessType() {
        return this.implicitPropertyAccessType;
    }

    @Override
    public String getDefaultAccessStrategyName() {
        return this.implicitPropertyAccessorName;
    }

    @Override
    public boolean isDefaultEntityLaziness() {
        return this.entitiesImplicitlyLazy;
    }

    @Override
    public boolean isDefaultCollectionLaziness() {
        return this.pluralAttributesImplicitlyLazy;
    }

    @Override
    public org.hibernate.cache.spi.access.AccessType getDefaultCacheAccessType() {
        return this.implicitCacheAccessType;
    }

    @Override
    public CollectionClassification getDefaultListClassification() {
        return this.implicitListClassification;
    }

    public static class Builder {
        private String implicitSchemaName;
        private String implicitCatalogName;
        private boolean implicitlyQuoteIdentifiers;
        private String implicitIdColumnName;
        private String implicitTenantIdColumnName;
        private String implicitDiscriminatorColumnName;
        private String implicitPackageName;
        private boolean autoImportEnabled;
        private final EnumSet<CascadeType> implicitCascadeTypes;
        private AccessType implicitPropertyAccessType;
        private String implicitPropertyAccessorName;
        private boolean entitiesImplicitlyLazy;
        private boolean pluralAttributesImplicitlyLazy;
        private org.hibernate.cache.spi.access.AccessType implicitCacheAccessType;
        private CollectionClassification implicitListClassification;

        public Builder(EffectiveMappingDefaults parentDefaults) {
            this.implicitSchemaName = parentDefaults.getDefaultSchemaName();
            this.implicitCatalogName = parentDefaults.getDefaultCatalogName();
            this.implicitlyQuoteIdentifiers = parentDefaults.isDefaultQuoteIdentifiers();
            this.implicitIdColumnName = parentDefaults.getDefaultIdColumnName();
            this.implicitTenantIdColumnName = parentDefaults.getDefaultTenantIdColumnName();
            this.implicitDiscriminatorColumnName = parentDefaults.getDefaultDiscriminatorColumnName();
            this.implicitPackageName = parentDefaults.getDefaultPackageName();
            this.autoImportEnabled = parentDefaults.isDefaultAutoImport();
            this.implicitCascadeTypes = parentDefaults.getDefaultCascadeTypes();
            this.implicitPropertyAccessType = parentDefaults.getDefaultPropertyAccessType();
            this.implicitPropertyAccessorName = parentDefaults.getDefaultAccessStrategyName();
            this.entitiesImplicitlyLazy = parentDefaults.isDefaultEntityLaziness();
            this.pluralAttributesImplicitlyLazy = parentDefaults.isDefaultCollectionLaziness();
            this.implicitCacheAccessType = parentDefaults.getDefaultCacheAccessType();
        }

        public Builder setImplicitSchemaName(String implicitSchemaName) {
            if (StringHelper.isNotEmpty(implicitSchemaName)) {
                this.implicitSchemaName = implicitSchemaName;
            }
            return this;
        }

        public Builder setImplicitCatalogName(String implicitCatalogName) {
            if (StringHelper.isNotEmpty(implicitCatalogName)) {
                this.implicitCatalogName = implicitCatalogName;
            }
            return this;
        }

        public Builder setImplicitlyQuoteIdentifiers(boolean implicitlyQuoteIdentifiers) {
            this.implicitlyQuoteIdentifiers = implicitlyQuoteIdentifiers;
            return this;
        }

        public Builder setImplicitIdColumnName(String implicitIdColumnName) {
            if (StringHelper.isNotEmpty(implicitIdColumnName)) {
                this.implicitIdColumnName = implicitIdColumnName;
            }
            return this;
        }

        public Builder setImplicitTenantIdColumnName(String implicitTenantIdColumnName) {
            if (StringHelper.isNotEmpty(implicitTenantIdColumnName)) {
                this.implicitTenantIdColumnName = implicitTenantIdColumnName;
            }
            return this;
        }

        public Builder setImplicitDiscriminatorColumnName(String implicitDiscriminatorColumnName) {
            if (StringHelper.isNotEmpty(implicitDiscriminatorColumnName)) {
                this.implicitDiscriminatorColumnName = implicitDiscriminatorColumnName;
            }
            return this;
        }

        public Builder setImplicitPackageName(String implicitPackageName) {
            if (StringHelper.isNotEmpty(implicitPackageName)) {
                this.implicitPackageName = implicitPackageName;
            }
            return this;
        }

        public Builder setAutoImportEnabled(boolean autoImportEnabled) {
            this.autoImportEnabled = autoImportEnabled;
            return this;
        }

        public Builder setImplicitPropertyAccessType(AccessType accessType) {
            if (accessType != null) {
                this.implicitPropertyAccessType = accessType;
            }
            return this;
        }

        public Builder setImplicitPropertyAccessorName(String implicitPropertyAccessorName) {
            if (StringHelper.isNotEmpty(implicitPropertyAccessorName)) {
                this.implicitPropertyAccessorName = implicitPropertyAccessorName;
            }
            return this;
        }

        public Builder setEntitiesImplicitlyLazy(boolean entitiesImplicitlyLazy) {
            this.entitiesImplicitlyLazy = entitiesImplicitlyLazy;
            return this;
        }

        public Builder setPluralAttributesImplicitlyLazy(boolean pluralAttributesImplicitlyLazy) {
            this.pluralAttributesImplicitlyLazy = pluralAttributesImplicitlyLazy;
            return this;
        }

        public Builder setImplicitCacheAccessType(org.hibernate.cache.spi.access.AccessType implicitCacheAccessType) {
            if (implicitCacheAccessType != null) {
                this.implicitCacheAccessType = implicitCacheAccessType;
            }
            return this;
        }

        public CollectionClassification getImplicitListClassification() {
            return this.implicitListClassification;
        }

        public Builder setImplicitListClassification(CollectionClassification implicitListClassification) {
            if (implicitListClassification != null) {
                this.implicitListClassification = implicitListClassification;
            }
            return this;
        }

        public OverriddenMappingDefaults build() {
            return new OverriddenMappingDefaults(this.implicitSchemaName, this.implicitCatalogName, this.implicitlyQuoteIdentifiers, this.implicitIdColumnName, this.implicitTenantIdColumnName, this.implicitDiscriminatorColumnName, this.implicitPackageName, this.autoImportEnabled, this.implicitCascadeTypes, this.implicitPropertyAccessType, this.implicitPropertyAccessorName, this.entitiesImplicitlyLazy, this.pluralAttributesImplicitlyLazy, this.implicitCacheAccessType, this.implicitListClassification);
        }
    }
}

