/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi.access;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.cache.spi.access.UnknownAccessTypeException;

public enum AccessType {
    READ_ONLY,
    READ_WRITE,
    NONSTRICT_READ_WRITE,
    TRANSACTIONAL;


    public String getExternalName() {
        return super.toString().toLowerCase(Locale.ROOT).replace('_', '-');
    }

    public String toString() {
        return "AccessType[" + this.getExternalName() + "]";
    }

    public static AccessType fromExternalName(@Nullable String externalName) {
        if (externalName == null) {
            return null;
        }
        for (AccessType accessType : AccessType.values()) {
            if (!accessType.getExternalName().equals(externalName)) continue;
            return accessType;
        }
        try {
            return AccessType.valueOf(externalName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new UnknownAccessTypeException(externalName);
        }
    }
}

