/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi.support;

import org.hibernate.cache.cfg.spi.CollectionDataCachingConfig;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.cfg.spi.EntityDataCachingConfig;
import org.hibernate.cache.cfg.spi.NaturalIdDataCachingConfig;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.SecondLevelCacheLogger;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.support.AbstractDomainDataRegion;
import org.hibernate.cache.spi.support.CollectionNonStrictReadWriteAccess;
import org.hibernate.cache.spi.support.CollectionReadOnlyAccess;
import org.hibernate.cache.spi.support.CollectionReadWriteAccess;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.cache.spi.support.EntityNonStrictReadWriteAccess;
import org.hibernate.cache.spi.support.EntityReadOnlyAccess;
import org.hibernate.cache.spi.support.EntityReadWriteAccess;
import org.hibernate.cache.spi.support.NaturalIdNonStrictReadWriteAccess;
import org.hibernate.cache.spi.support.NaturalIdReadOnlyAccess;
import org.hibernate.cache.spi.support.NaturalIdReadWriteAccess;
import org.hibernate.metamodel.model.domain.NavigableRole;

public class DomainDataRegionTemplate
extends AbstractDomainDataRegion {
    private final DomainDataStorageAccess storageAccess;

    public DomainDataRegionTemplate(DomainDataRegionConfig regionConfig, RegionFactory regionFactory, DomainDataStorageAccess storageAccess, CacheKeysFactory defaultKeysFactory, DomainDataRegionBuildingContext buildingContext) {
        super(regionConfig, regionFactory, defaultKeysFactory, buildingContext);
        this.storageAccess = storageAccess;
        this.completeInstantiation(regionConfig, buildingContext);
    }

    public DomainDataStorageAccess getCacheStorageAccess() {
        return this.storageAccess;
    }

    @Override
    public EntityDataAccess generateEntityAccess(EntityDataCachingConfig entityAccessConfig) {
        NavigableRole namedEntityRole = entityAccessConfig.getNavigableRole();
        AccessType accessType = entityAccessConfig.getAccessType();
        SecondLevelCacheLogger.L2CACHE_LOGGER.tracef("Generating entity cache access [%s] : %s", accessType.getExternalName(), namedEntityRole);
        return switch (accessType) {
            default -> throw new IncompatibleClassChangeError();
            case AccessType.READ_ONLY -> this.generateReadOnlyEntityAccess(entityAccessConfig);
            case AccessType.READ_WRITE -> this.generateReadWriteEntityAccess(entityAccessConfig);
            case AccessType.NONSTRICT_READ_WRITE -> this.generateNonStrictReadWriteEntityAccess(entityAccessConfig);
            case AccessType.TRANSACTIONAL -> this.generateTransactionalEntityDataAccess(entityAccessConfig);
        };
    }

    protected EntityDataAccess generateReadOnlyEntityAccess(EntityDataCachingConfig accessConfig) {
        return new EntityReadOnlyAccess(this, this.getEffectiveKeysFactory(), this.getCacheStorageAccess(), accessConfig);
    }

    protected EntityDataAccess generateReadWriteEntityAccess(EntityDataCachingConfig accessConfig) {
        return new EntityReadWriteAccess(this, this.getEffectiveKeysFactory(), this.getCacheStorageAccess(), accessConfig);
    }

    protected EntityDataAccess generateNonStrictReadWriteEntityAccess(EntityDataCachingConfig accessConfig) {
        return new EntityNonStrictReadWriteAccess(this, this.getEffectiveKeysFactory(), this.getCacheStorageAccess(), accessConfig);
    }

    protected EntityDataAccess generateTransactionalEntityDataAccess(EntityDataCachingConfig entityAccessConfig) {
        throw this.generateTransactionalNotSupportedException();
    }

    private UnsupportedOperationException generateTransactionalNotSupportedException() {
        return new UnsupportedOperationException("Cache provider [" + String.valueOf(this.getRegionFactory()) + "] does not support `" + AccessType.TRANSACTIONAL.getExternalName() + "` access");
    }

    @Override
    public NaturalIdDataAccess generateNaturalIdAccess(NaturalIdDataCachingConfig accessConfig) {
        NavigableRole namedEntityRole = accessConfig.getNavigableRole();
        AccessType accessType = accessConfig.getAccessType();
        SecondLevelCacheLogger.L2CACHE_LOGGER.tracef("Generating entity natural-id access [%s] : %s", accessType.getExternalName(), namedEntityRole);
        return switch (accessType) {
            default -> throw new IncompatibleClassChangeError();
            case AccessType.READ_ONLY -> this.generateReadOnlyNaturalIdAccess(accessConfig);
            case AccessType.READ_WRITE -> this.generateReadWriteNaturalIdAccess(accessConfig);
            case AccessType.NONSTRICT_READ_WRITE -> this.generateNonStrictReadWriteNaturalIdAccess(accessConfig);
            case AccessType.TRANSACTIONAL -> this.generateTransactionalNaturalIdDataAccess(accessConfig);
        };
    }

    protected NaturalIdDataAccess generateReadOnlyNaturalIdAccess(NaturalIdDataCachingConfig accessConfig) {
        return new NaturalIdReadOnlyAccess(this, this.getEffectiveKeysFactory(), this.getCacheStorageAccess(), accessConfig);
    }

    protected NaturalIdDataAccess generateReadWriteNaturalIdAccess(NaturalIdDataCachingConfig accessConfig) {
        return new NaturalIdReadWriteAccess(this, this.getEffectiveKeysFactory(), this.getCacheStorageAccess(), accessConfig);
    }

    protected NaturalIdDataAccess generateNonStrictReadWriteNaturalIdAccess(NaturalIdDataCachingConfig accessConfig) {
        return new NaturalIdNonStrictReadWriteAccess(this, this.getEffectiveKeysFactory(), this.getCacheStorageAccess(), accessConfig);
    }

    protected NaturalIdDataAccess generateTransactionalNaturalIdDataAccess(NaturalIdDataCachingConfig accessConfig) {
        throw this.generateTransactionalNotSupportedException();
    }

    @Override
    public CollectionDataAccess generateCollectionAccess(CollectionDataCachingConfig accessConfig) {
        NavigableRole namedCollectionRole = accessConfig.getNavigableRole();
        if (SecondLevelCacheLogger.L2CACHE_LOGGER.isTraceEnabled()) {
            SecondLevelCacheLogger.L2CACHE_LOGGER.trace("Generating collection cache access: " + String.valueOf(namedCollectionRole));
        }
        return switch (accessConfig.getAccessType()) {
            default -> throw new IncompatibleClassChangeError();
            case AccessType.READ_ONLY -> this.generateReadOnlyCollectionAccess(accessConfig);
            case AccessType.READ_WRITE -> this.generateReadWriteCollectionAccess(accessConfig);
            case AccessType.NONSTRICT_READ_WRITE -> this.generateNonStrictReadWriteCollectionAccess(accessConfig);
            case AccessType.TRANSACTIONAL -> this.generateTransactionalCollectionDataAccess(accessConfig);
        };
    }

    private CollectionDataAccess generateReadOnlyCollectionAccess(CollectionDataCachingConfig accessConfig) {
        return new CollectionReadOnlyAccess(this, this.getEffectiveKeysFactory(), this.getCacheStorageAccess(), accessConfig);
    }

    private CollectionDataAccess generateReadWriteCollectionAccess(CollectionDataCachingConfig accessConfig) {
        return new CollectionReadWriteAccess(this, this.getEffectiveKeysFactory(), this.getCacheStorageAccess(), accessConfig);
    }

    private CollectionDataAccess generateNonStrictReadWriteCollectionAccess(CollectionDataCachingConfig accessConfig) {
        return new CollectionNonStrictReadWriteAccess(this, this.getEffectiveKeysFactory(), this.getCacheStorageAccess(), accessConfig);
    }

    protected CollectionDataAccess generateTransactionalCollectionDataAccess(CollectionDataCachingConfig accessConfig) {
        throw this.generateTransactionalNotSupportedException();
    }
}

