/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.JsonValueFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonValueEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonValueErrorBehavior;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLJsonValueFunction
extends JsonValueFunction {
    private final boolean supportsStandard;

    public PostgreSQLJsonValueFunction(boolean supportsStandard, TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, true);
        this.supportsStandard = supportsStandard;
    }

    @Override
    protected void render(SqlAppender sqlAppender, JsonValueFunction.JsonValueArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (this.supportsStandard) {
            super.render(sqlAppender, arguments, returnType, walker);
            if (this.isString(arguments.returningType())) {
                sqlAppender.appendSql("#>>'{}'");
            }
        } else {
            if (arguments.errorBehavior() != null && arguments.errorBehavior() != JsonValueErrorBehavior.ERROR) {
                throw new QueryException("Can't emulate on error clause on PostgreSQL");
            }
            if (arguments.emptyBehavior() != null && arguments.emptyBehavior() != JsonValueEmptyBehavior.NULL) {
                throw new QueryException("Can't emulate on empty clause on PostgreSQL");
            }
            PostgreSQLJsonValueFunction.appendJsonValue(sqlAppender, arguments.jsonDocument(), arguments.jsonPath(), arguments.isJsonType(), arguments.returningType(), arguments.passingClause(), walker);
        }
    }

    @Override
    protected void renderReturningClause(SqlAppender sqlAppender, JsonValueFunction.JsonValueArguments arguments, SqlAstTranslator<?> walker) {
        if (this.supportsStandard && this.isString(arguments.returningType())) {
            sqlAppender.appendSql(" returning jsonb");
        } else {
            super.renderReturningClause(sqlAppender, arguments, walker);
        }
    }

    private boolean isString(@Nullable CastTarget castTarget) {
        return castTarget == null || castTarget.getJdbcMapping().getJdbcType().isString();
    }

    static void appendJsonValue(SqlAppender sqlAppender, Expression jsonDocument, SqlAstNode jsonPath, boolean isJsonType, @Nullable CastTarget castTarget, @Nullable JsonPathPassingClause passingClause, SqlAstTranslator<?> walker) {
        boolean needsCast;
        if (castTarget != null) {
            sqlAppender.appendSql("cast(");
        }
        sqlAppender.appendSql("jsonb_path_query_first(");
        boolean bl = needsCast = !isJsonType && AbstractSqlAstTranslator.isParameter(jsonDocument);
        if (needsCast) {
            sqlAppender.appendSql("cast(");
        }
        jsonDocument.accept(walker);
        if (needsCast) {
            sqlAppender.appendSql(" as jsonb)");
        }
        sqlAppender.appendSql(',');
        if (jsonPath instanceof Literal) {
            jsonPath.accept(walker);
        } else {
            sqlAppender.appendSql("cast(");
            jsonPath.accept(walker);
            sqlAppender.appendSql(" as jsonpath)");
        }
        if (passingClause != null) {
            sqlAppender.append(",jsonb_build_object");
            int separator = 40;
            for (Map.Entry<String, Expression> entry : passingClause.getPassingExpressions().entrySet()) {
                sqlAppender.append((char)separator);
                sqlAppender.appendSingleQuoteEscapedString(entry.getKey());
                sqlAppender.append(',');
                entry.getValue().accept(walker);
                separator = 44;
            }
            sqlAppender.append(')');
        }
        sqlAppender.appendSql(")#>>'{}'");
        if (castTarget != null) {
            sqlAppender.appendSql(" as ");
            castTarget.accept(walker);
            sqlAppender.appendSql(')');
        }
    }
}

