/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.spi;

import jakarta.persistence.Timeout;
import java.sql.Connection;
import org.hibernate.Incubating;
import org.hibernate.engine.spi.SessionFactoryImplementor;

@Incubating
public interface ConnectionLockTimeoutStrategy {
    public static final ConnectionLockTimeoutStrategy NONE = () -> Level.NONE;

    public Level getSupportedLevel();

    default public Timeout getLockTimeout(Connection connection, SessionFactoryImplementor factory) {
        throw new UnsupportedOperationException("Lock timeout on the JDBC connection is not supported");
    }

    default public void setLockTimeout(Timeout timeout, Connection connection, SessionFactoryImplementor factory) {
        throw new UnsupportedOperationException("Lock timeout on the JDBC connection is not supported");
    }

    public static enum Level {
        NONE,
        SUPPORTED,
        EXTENDED;

    }
}

