/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.complete;

import java.util.Arrays;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.FromClauseAccessImpl;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.complete.CompleteResultBuilderCollection;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBaseConstant;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class CompleteResultBuilderCollectionStandard
implements CompleteResultBuilderCollection,
NativeQuery.CollectionReturn {
    private final String tableAlias;
    private final NavigablePath navigablePath;
    private final PluralAttributeMapping pluralAttributeDescriptor;
    private final String[] keyColumnNames;
    private final String[] indexColumnNames;
    private final String[] elementColumnNames;

    public CompleteResultBuilderCollectionStandard(String tableAlias, NavigablePath navigablePath, PluralAttributeMapping pluralAttributeDescriptor) {
        this(tableAlias, navigablePath, pluralAttributeDescriptor, null, null, null);
    }

    public CompleteResultBuilderCollectionStandard(String tableAlias, NavigablePath navigablePath, PluralAttributeMapping pluralAttributeDescriptor, String[] keyColumnNames, String[] indexColumnNames, String[] elementColumnNames) {
        this.tableAlias = tableAlias;
        this.navigablePath = navigablePath;
        this.pluralAttributeDescriptor = pluralAttributeDescriptor;
        this.keyColumnNames = keyColumnNames;
        this.indexColumnNames = indexColumnNames;
        this.elementColumnNames = elementColumnNames;
    }

    @Override
    public Class<?> getJavaType() {
        return this.pluralAttributeDescriptor.getExpressibleJavaType().getJavaTypeClass();
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public PluralAttributeMapping getPluralAttribute() {
        return this.pluralAttributeDescriptor;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public DomainResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        FromClauseAccessImpl fromClauseAccess = creationStateImpl.getFromClauseAccess();
        TableGroup rootTableGroup = this.pluralAttributeDescriptor.createRootTableGroup(false, this.navigablePath, this.tableAlias, new SqlAliasBaseConstant(this.tableAlias), null, creationStateImpl);
        fromClauseAccess.registerTableGroup(this.navigablePath, rootTableGroup);
        this.resolveSelections(rootTableGroup, this.pluralAttributeDescriptor.getKeyDescriptor(), this.keyColumnNames, jdbcResultsMetadata, creationStateImpl);
        if (this.pluralAttributeDescriptor.getIndexDescriptor() != null) {
            this.resolveSelections(rootTableGroup, this.pluralAttributeDescriptor.getIndexDescriptor(), this.indexColumnNames, jdbcResultsMetadata, creationStateImpl);
        }
        this.resolveSelections(rootTableGroup, this.pluralAttributeDescriptor.getElementDescriptor(), this.elementColumnNames, jdbcResultsMetadata, creationStateImpl);
        return this.pluralAttributeDescriptor.createDomainResult(this.navigablePath, rootTableGroup, null, domainResultCreationState);
    }

    private void resolveSelections(TableGroup tableGroup, ModelPart modelPart, String[] columnNames, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationStateImpl creationStateImpl) {
        CompleteResultBuilderCollectionStandard.resolveSelections(modelPart, (selectionIndex, selectableMapping) -> creationStateImpl.resolveSqlSelection(ResultsHelper.resolveSqlExpression(creationStateImpl, jdbcResultsMetadata, tableGroup.resolveTableReference(selectableMapping.getContainingTableExpression()), selectableMapping, columnNames[selectionIndex]), selectableMapping.getJdbcMapping().getJdbcJavaType(), null, creationStateImpl.getSessionFactory().getTypeConfiguration()));
    }

    private static void resolveSelections(ModelPart modelPart, SelectableConsumer consumer) {
        if (modelPart instanceof EntityValuedModelPart) {
            EntityValuedModelPart entityValuedModelPart = (EntityValuedModelPart)modelPart;
            EntityMappingType entityMappingType = entityValuedModelPart.getEntityMappingType();
            int index = entityMappingType.getIdentifierMapping().forEachSelectable(consumer);
            if (entityMappingType.getDiscriminatorMapping() != null) {
                index += entityMappingType.getDiscriminatorMapping().forEachSelectable(index, consumer);
            }
            entityMappingType.forEachSelectable(index, consumer);
        } else {
            modelPart.forEachSelectable(consumer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteResultBuilderCollectionStandard that = (CompleteResultBuilderCollectionStandard)o;
        return this.tableAlias.equals(that.tableAlias) && this.navigablePath.equals(that.navigablePath) && this.pluralAttributeDescriptor.equals(that.pluralAttributeDescriptor) && Arrays.equals(this.keyColumnNames, that.keyColumnNames) && Arrays.equals(this.indexColumnNames, that.indexColumnNames) && Arrays.equals(this.elementColumnNames, that.elementColumnNames);
    }

    public int hashCode() {
        int result = this.tableAlias.hashCode();
        result = 31 * result + this.navigablePath.hashCode();
        result = 31 * result + this.pluralAttributeDescriptor.hashCode();
        result = 31 * result + Arrays.hashCode(this.keyColumnNames);
        result = 31 * result + Arrays.hashCode(this.indexColumnNames);
        result = 31 * result + Arrays.hashCode(this.elementColumnNames);
        return result;
    }
}

