/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import java.util.Objects;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.predicate.AbstractSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;

public abstract class AbstractNegatableSqmPredicate
extends AbstractSqmPredicate
implements SqmNegatablePredicate {
    private boolean negated;

    public AbstractNegatableSqmPredicate(NodeBuilder nodeBuilder) {
        this(false, nodeBuilder);
    }

    public AbstractNegatableSqmPredicate(boolean negated, NodeBuilder nodeBuilder) {
        this(nodeBuilder.getBooleanType(), negated, nodeBuilder);
    }

    public AbstractNegatableSqmPredicate(SqmBindableType<Boolean> type, boolean negated, NodeBuilder nodeBuilder) {
        super(type, nodeBuilder);
        this.negated = negated;
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public void negate() {
        this.negated = !this.negated;
    }

    protected abstract SqmNegatablePredicate createNegatedNode();

    @Override
    public SqmNegatablePredicate not() {
        return this.createNegatedNode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof AbstractNegatableSqmPredicate)) return false;
        AbstractNegatableSqmPredicate that = (AbstractNegatableSqmPredicate)other;
        if (this.negated != that.negated) return false;
        if (this.getClass() != that.getClass()) return false;
        if (!Objects.equals(this.toHqlString(), that.toHqlString())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.negated);
    }
}

