/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format;

import java.sql.SQLException;
import org.hibernate.internal.util.CharSequenceHelper;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JdbcDateJavaType;
import org.hibernate.type.descriptor.java.JdbcTimeJavaType;
import org.hibernate.type.descriptor.java.JdbcTimestampJavaType;
import org.hibernate.type.descriptor.java.OffsetDateTimeJavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.StructAttributeValues;
import org.hibernate.type.descriptor.jdbc.StructHelper;
import org.hibernate.type.format.JsonDocumentReader;
import org.hibernate.type.format.JsonValueJDBCTypeAdapter;

public class StringJsonValueJDBCTypeAdapter
implements JsonValueJDBCTypeAdapter {
    private boolean returnEmbeddable;

    public StringJsonValueJDBCTypeAdapter(boolean returnEmbeddable) {
        this.returnEmbeddable = returnEmbeddable;
    }

    @Override
    public Object fromValue(JavaType<?> jdbcJavaType, JdbcType jdbcType, JsonDocumentReader source, WrapperOptions options) throws SQLException {
        return this.fromAnyValue(jdbcJavaType, jdbcType, source, options);
    }

    private Object fromAnyValue(JavaType<?> jdbcJavaType, JdbcType jdbcType, JsonDocumentReader source, WrapperOptions options) throws SQLException {
        String string = source.getStringValue();
        switch (jdbcType.getDefaultSqlTypeCode()) {
            case -4: 
            case -3: 
            case -2: 
            case 4003: {
                return jdbcJavaType.wrap((byte[])PrimitiveByteArrayJavaType.INSTANCE.fromEncodedString(string, 0, string.length()), options);
            }
            case 3000: {
                return jdbcJavaType.wrap(PrimitiveByteArrayJavaType.INSTANCE.fromString(string.substring(0, string.length()).replace("-", "")), options);
            }
            case 91: {
                return jdbcJavaType.wrap(JdbcDateJavaType.INSTANCE.fromEncodedString(string, 0, string.length()), options);
            }
            case 92: 
            case 2013: 
            case 3007: {
                return jdbcJavaType.wrap(JdbcTimeJavaType.INSTANCE.fromEncodedString(string, 0, string.length()), options);
            }
            case 93: {
                return jdbcJavaType.wrap(JdbcTimestampJavaType.INSTANCE.fromEncodedString(string, 0, string.length()), options);
            }
            case 2014: 
            case 3003: {
                return jdbcJavaType.wrap(OffsetDateTimeJavaType.INSTANCE.fromEncodedString(string, 0, string.length()), options);
            }
            case -6: 
            case 4: 
            case 5: {
                if (jdbcJavaType.getJavaTypeClass() == Boolean.class) {
                    return jdbcJavaType.wrap(Integer.parseInt(string, 0, string.length(), 10), options);
                }
                if (jdbcJavaType instanceof EnumJavaType) {
                    return jdbcJavaType.wrap(Integer.parseInt(string, 0, string.length(), 10), options);
                }
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                if (jdbcJavaType.getJavaTypeClass() != Boolean.class || string.length() != 1) break;
                return jdbcJavaType.wrap(Character.valueOf(string.charAt(0)), options);
            }
        }
        if (jdbcType instanceof AggregateJdbcType) {
            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)jdbcType;
            Object[] subValues = aggregateJdbcType.extractJdbcValues(CharSequenceHelper.subSequence(string, 0, string.length()), options);
            if (this.returnEmbeddable) {
                StructAttributeValues subAttributeValues = StructHelper.getAttributeValues(aggregateJdbcType.getEmbeddableMappingType(), subValues, options);
                EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
                return StructHelper.instantiate(embeddableMappingType, subAttributeValues);
            }
            return subValues;
        }
        return jdbcJavaType.fromEncodedString(string);
    }

    @Override
    public Object fromNumericValue(JavaType<?> jdbcJavaType, JdbcType jdbcType, JsonDocumentReader source, WrapperOptions options) throws SQLException {
        return this.fromAnyValue(jdbcJavaType, jdbcType, source, options);
    }
}

