/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.httpcore.UndertowOptionMap;
import io.undertow.httpcore.UndertowOptions;
import io.undertow.server.HttpServerExchange;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueryParameterUtils {
    private QueryParameterUtils() {
    }

    public static String buildQueryString(Map<String, Deque<String>> params) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Deque<String>> entry : params.entrySet()) {
            if (entry.getValue().isEmpty()) {
                if (first) {
                    first = false;
                } else {
                    sb.append('&');
                }
                sb.append(entry.getKey());
                sb.append('=');
                continue;
            }
            for (String val : entry.getValue()) {
                if (first) {
                    first = false;
                } else {
                    sb.append('&');
                }
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(val);
            }
        }
        return sb.toString();
    }

    @Deprecated
    public static Map<String, Deque<String>> parseQueryString(String newQueryString) {
        return QueryParameterUtils.parseQueryString(newQueryString, null);
    }

    public static Map<String, Deque<String>> parseQueryString(String newQueryString, String encoding) {
        LinkedHashMap<String, Deque<String>> newQueryParameters = new LinkedHashMap<String, Deque<String>>();
        int startPos = 0;
        int equalPos = -1;
        boolean needsDecode = false;
        for (int i = 0; i < newQueryString.length(); ++i) {
            char c = newQueryString.charAt(i);
            if (c == '=' && equalPos == -1) {
                equalPos = i;
                continue;
            }
            if (c == '&') {
                QueryParameterUtils.handleQueryParameter(newQueryString, newQueryParameters, startPos, equalPos, i, encoding, needsDecode);
                needsDecode = false;
                startPos = i + 1;
                equalPos = -1;
                continue;
            }
            if (c != '%' && c != '+' || encoding == null) continue;
            needsDecode = true;
        }
        if (startPos != newQueryString.length()) {
            QueryParameterUtils.handleQueryParameter(newQueryString, newQueryParameters, startPos, equalPos, newQueryString.length(), encoding, needsDecode);
        }
        return newQueryParameters;
    }

    private static void handleQueryParameter(String newQueryString, Map<String, Deque<String>> newQueryParameters, int startPos, int equalPos, int i, String encoding, boolean needsDecode) {
        String key;
        String value = "";
        if (equalPos == -1) {
            key = QueryParameterUtils.decodeParam(newQueryString, startPos, i, encoding, needsDecode);
        } else {
            key = QueryParameterUtils.decodeParam(newQueryString, startPos, equalPos, encoding, needsDecode);
            value = QueryParameterUtils.decodeParam(newQueryString, equalPos + 1, i, encoding, needsDecode);
        }
        Deque<String> queue = newQueryParameters.get(key);
        if (queue == null) {
            queue = new ArrayDeque<String>(1);
            newQueryParameters.put(key, queue);
        }
        if (value != null) {
            queue.add(value);
        }
    }

    private static String decodeParam(String newQueryString, int startPos, int equalPos, String encoding, boolean needsDecode) {
        String key;
        if (needsDecode) {
            try {
                key = URLDecoder.decode(newQueryString.substring(startPos, equalPos), encoding);
            }
            catch (UnsupportedEncodingException e) {
                key = newQueryString.substring(startPos, equalPos);
            }
        } else {
            key = newQueryString.substring(startPos, equalPos);
        }
        return key;
    }

    @Deprecated
    public static Map<String, Deque<String>> mergeQueryParametersWithNewQueryString(Map<String, Deque<String>> queryParameters, String newQueryString) {
        return QueryParameterUtils.mergeQueryParametersWithNewQueryString(queryParameters, newQueryString, StandardCharsets.UTF_8.name());
    }

    public static Map<String, Deque<String>> mergeQueryParametersWithNewQueryString(Map<String, Deque<String>> queryParameters, String newQueryString, String encoding) {
        Map<String, Deque<String>> newQueryParameters = QueryParameterUtils.parseQueryString(newQueryString, encoding);
        for (Map.Entry<String, Deque<String>> entry : queryParameters.entrySet()) {
            if (!newQueryParameters.containsKey(entry.getKey())) {
                newQueryParameters.put(entry.getKey(), new ArrayDeque(entry.getValue()));
                continue;
            }
            newQueryParameters.get(entry.getKey()).addAll((Collection<String>)entry.getValue());
        }
        return newQueryParameters;
    }

    public static String getQueryParamEncoding(HttpServerExchange exchange) {
        String encoding = null;
        UndertowOptionMap undertowOptions = exchange.getUndertowOptions();
        if (undertowOptions.get(UndertowOptions.DECODE_URL, true)) {
            encoding = (String)undertowOptions.get(UndertowOptions.URL_CHARSET, (Object)StandardCharsets.UTF_8.name());
        }
        return encoding;
    }
}

