/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.security.KeyStore;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.x500.X500;

public interface Credential
extends Cloneable {
    public static final Credential[] NO_CREDENTIALS = new Credential[0];

    default public boolean canVerify(Class<? extends Evidence> evidenceClass, String algorithmName) {
        Assert.checkNotNullParam((String)"evidenceClass", evidenceClass);
        return false;
    }

    default public boolean canVerify(Evidence evidence) {
        Assert.checkNotNullParam((String)"evidence", (Object)evidence);
        return this.canVerify(evidence.getClass(), evidence instanceof AlgorithmEvidence ? ((AlgorithmEvidence)evidence).getAlgorithm() : null);
    }

    @Deprecated
    default public boolean verify(Evidence evidence) {
        return this.verify(ProviderUtil.INSTALLED_PROVIDERS, evidence);
    }

    default public boolean verify(Supplier<Provider[]> providerSupplier, Evidence evidence) {
        Assert.checkNotNullParam((String)"providerSupplier", providerSupplier);
        Assert.checkNotNullParam((String)"evidence", (Object)evidence);
        return false;
    }

    default public <C extends Credential> C castAs(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
        return (C)((Credential)this.castAndApply(credentialType, algorithmName, parameterSpec, Function.identity()));
    }

    default public <C extends Credential> C castAs(Class<C> credentialType, String algorithmName) {
        return (C)((Credential)this.castAndApply(credentialType, algorithmName, Function.identity()));
    }

    default public <C extends Credential> C castAs(Class<C> credentialType) {
        return (C)((Credential)this.castAndApply(credentialType, Function.identity()));
    }

    default public <C extends Credential, R> R castAndApply(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) {
        return this.matches(credentialType, algorithmName, parameterSpec) ? (R)function.apply((Credential)credentialType.cast(this)) : null;
    }

    default public <C extends Credential, R> R castAndApply(Class<C> credentialType, String algorithmName, Function<C, R> function) {
        return this.matches(credentialType, algorithmName, null) ? (R)function.apply((Credential)credentialType.cast(this)) : null;
    }

    default public <C extends Credential, R> R castAndApply(Class<C> credentialType, Function<C, R> function) {
        return credentialType.isInstance(this) ? (R)function.apply((Credential)credentialType.cast(this)) : null;
    }

    public Credential clone();

    default public boolean matches(Credential other) {
        return other instanceof AlgorithmCredential ? this.matches((AlgorithmCredential)other) : other != null && this.getClass() == other.getClass();
    }

    default public boolean matches(AlgorithmCredential other) {
        return false;
    }

    default public boolean matches(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
        return credentialType.isInstance(this) && algorithmName == null && parameterSpec == null;
    }

    public static Credential fromKeyStoreEntry(KeyStore.Entry keyStoreEntry) {
        Assert.checkNotNullParam((String)"keyStoreEntry", (Object)keyStoreEntry);
        if (keyStoreEntry instanceof PasswordEntry) {
            return new PasswordCredential(((PasswordEntry)keyStoreEntry).getPassword());
        }
        if (keyStoreEntry instanceof KeyStore.PrivateKeyEntry) {
            return new X509CertificateChainPrivateCredential(((KeyStore.PrivateKeyEntry)keyStoreEntry).getPrivateKey(), X500.asX509CertificateArray((Object[])((KeyStore.PrivateKeyEntry)keyStoreEntry).getCertificateChain()));
        }
        if (keyStoreEntry instanceof KeyStore.TrustedCertificateEntry) {
            return new X509CertificateChainPublicCredential((X509Certificate)((KeyStore.TrustedCertificateEntry)keyStoreEntry).getTrustedCertificate());
        }
        if (keyStoreEntry instanceof KeyStore.SecretKeyEntry) {
            return new SecretKeyCredential(((KeyStore.SecretKeyEntry)keyStoreEntry).getSecretKey());
        }
        return null;
    }
}

