/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheJoinInfo;

public class CacheJoinCommand
extends AbstractCacheControlCommand {
    public static final byte COMMAND_ID = 85;
    private String cacheName;
    private CacheJoinInfo joinInfo;
    private int viewId;

    public CacheJoinCommand() {
        super((byte)85);
    }

    public CacheJoinCommand(String cacheName, Address origin, CacheJoinInfo joinInfo, int viewId) {
        super((byte)85, origin);
        this.cacheName = cacheName;
        this.joinInfo = joinInfo;
        this.viewId = viewId;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        return gcr.getClusterTopologyManager().handleJoin(this.cacheName, this.origin, this.joinInfo, this.viewId);
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString((String)this.cacheName, (ObjectOutput)output);
        output.writeObject(this.joinInfo);
        output.writeInt(this.viewId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheName = MarshallUtil.unmarshallString((ObjectInput)input);
        this.joinInfo = (CacheJoinInfo)input.readObject();
        this.viewId = input.readInt();
    }

    public String toString() {
        return "TopologyJoinCommand{cacheName='" + this.cacheName + "', origin=" + String.valueOf(this.origin) + ", joinInfo=" + String.valueOf(this.joinInfo) + ", viewId=" + this.viewId + "}";
    }
}

