/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning.irac;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.protostream.descriptors.Type;

@ProtoTypeId(value=1007)
public class TopologyIracVersion
implements Comparable<TopologyIracVersion> {
    public static final TopologyIracVersion NO_VERSION = new TopologyIracVersion(0, 0L);
    private static final Pattern PARSE_PATTERN = Pattern.compile("\\((\\d+):(\\d+)\\)");
    private final int topologyId;
    private final long version;

    private TopologyIracVersion(int topologyId, long version) {
        this.topologyId = topologyId;
        this.version = version;
    }

    @ProtoFactory
    public static TopologyIracVersion create(int topologyId, long version) {
        return topologyId == 0 && version == 0L ? NO_VERSION : new TopologyIracVersion(topologyId, version);
    }

    public static TopologyIracVersion newVersion(int currentTopologyId) {
        return new TopologyIracVersion(currentTopologyId, 1L);
    }

    public static TopologyIracVersion max(TopologyIracVersion v1, TopologyIracVersion v2) {
        return v1.compareTo(v2) < 0 ? v2 : v1;
    }

    public static TopologyIracVersion fromString(String s) {
        Matcher m = PARSE_PATTERN.matcher(s);
        if (!m.find()) {
            return null;
        }
        int topology = Integer.parseInt(m.group(1));
        long version = Long.parseLong(m.group(2));
        return new TopologyIracVersion(topology, version);
    }

    @ProtoField(number=1, type=Type.UINT32, defaultValue="0")
    public int getTopologyId() {
        return this.topologyId;
    }

    @ProtoField(number=2, type=Type.UINT64, defaultValue="0")
    public long getVersion() {
        return this.version;
    }

    public TopologyIracVersion increment(int currentTopologyId) {
        return currentTopologyId > this.topologyId ? TopologyIracVersion.newVersion(currentTopologyId) : new TopologyIracVersion(this.topologyId, this.version + 1L);
    }

    @Override
    public int compareTo(TopologyIracVersion other) {
        int topologyCompare = Integer.compare(this.topologyId, other.topologyId);
        return topologyCompare == 0 ? Long.compare(this.version, other.version) : topologyCompare;
    }

    public String toString() {
        return "(" + Integer.toString(this.topologyId) + ":" + this.version + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyIracVersion that = (TopologyIracVersion)o;
        return this.topologyId == that.topologyId && this.version == that.version;
    }

    public int hashCode() {
        int result = this.topologyId;
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }
}

