/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.impl;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollectors;
import org.infinispan.remoting.transport.ValidResponseCollector;

public class FilterMapResponseCollector
extends ValidResponseCollector<Map<Address, Response>> {
    private final HashMap<Address, Response> map;
    private final ResponseFilter filter;
    private final boolean waitForAll;

    public FilterMapResponseCollector(ResponseFilter filter, boolean waitForAll, int expectedSize) {
        this.map = new HashMap(expectedSize);
        this.filter = filter;
        this.waitForAll = waitForAll;
    }

    @Override
    protected Map<Address, Response> addValidResponse(Address sender, ValidResponse response) {
        boolean isDone;
        if (this.filter != null) {
            boolean isAcceptable = this.filter.isAcceptable(response, sender);
            isDone = this.waitForAll ? !this.filter.needMoreResponses() : isAcceptable;
        } else {
            isDone = !this.waitForAll;
        }
        this.map.put(sender, response);
        return isDone ? this.map : null;
    }

    @Override
    protected Map<Address, Response> addTargetNotFound(Address sender) {
        this.map.put(sender, CacheNotFoundResponse.INSTANCE);
        return null;
    }

    @Override
    protected Map<Address, Response> addException(Address sender, Exception exception) {
        throw ResponseCollectors.wrapRemoteException(sender, exception);
    }

    @Override
    public Map<Address, Response> finish() {
        return this.map;
    }
}

